/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class MarkerPagingProvider
extends RestPagingProvider {
    private final String markerParamName;
    private final String nextMarkerExpression;
    private boolean firstPage = true;
    private String nextMarker;

    public MarkerPagingProvider(String markerParamName, String nextMarkerExpression, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, String payloadExpression, MediaType defaultMediaType, Map<String, Object> parameterBindings, Map<String, Object> customParameterBindings, int responseTimeout) {
        super(requestFactory, expressionLanguage, payloadExpression, defaultMediaType, parameterBindings, customParameterBindings, responseTimeout);
        this.markerParamName = markerParamName;
        this.nextMarkerExpression = nextMarkerExpression;
    }

    @Override
    protected void configureRequest(RestRequestBuilder requestBuilder) {
        if (!this.firstPage) {
            if (RestSdkUtils.isBlank(this.nextMarker)) {
                this.stopPaging();
                return;
            }
            requestBuilder.addQueryParam(this.markerParamName, this.nextMarker);
        }
    }

    @Override
    protected void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, HttpResponseAttributes responseAttributes) {
        this.firstPage = false;
        if (RestSdkUtils.isBlank((CharSequence)rawPage.getValue())) {
            this.nextMarker = null;
            this.stopPaging();
        } else {
            this.nextMarker = (String)this.evaluate(rawPage, this.nextMarkerExpression, DataType.STRING, responseAttributes).getValue();
        }
    }
}

