/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception.expression;

import com.mulesoft.connectivity.rest.commons.api.interception.HttpRequest;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import java.util.Objects;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class PreconditionHttpResponseInterceptorDelegate
implements HttpResponseInterceptor {
    private Matcher precondition;
    private HttpResponseInterceptor delegate;

    public PreconditionHttpResponseInterceptorDelegate(Matcher precondition, HttpResponseInterceptor delegate) {
        Objects.requireNonNull(precondition);
        Objects.requireNonNull(delegate);
        this.precondition = precondition;
        this.delegate = delegate;
    }

    @Override
    public HttpResponse intercept(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (!this.precondition.match(httpResponse.getStatusCode())) {
            return httpResponse;
        }
        return this.delegate.intercept(httpRequest, httpResponse);
    }

    public static interface Matcher {
        public boolean match(int var1);
    }
}

