/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class SequenceCompositeDataExpression
implements DataExpression {
    private final List<Step> steps = new ArrayList<Step>();

    public SequenceCompositeDataExpression(List<Step> steps) {
        this.steps.addAll(steps);
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        for (Step step : this.steps) {
            Object result = step.getDataExpression().evaluate(evaluationContext);
            this.defineResultForNextEvaluationContext(evaluationContext, result);
            this.defineStepForNextEvaluationContext(evaluationContext, step, result);
        }
        return this.collectResultFromEvaluationContext(evaluationContext);
    }

    private void defineStepForNextEvaluationContext(EvaluationContext evaluationContext, Step step, Object result) {
        if (step.getName().isPresent()) {
            HashMap<String, Object> stepResult = new HashMap<String, Object>();
            if (result instanceof Result) {
                Result resultResult = (Result)result;
                stepResult.put("payload", resultResult.getOutput());
                stepResult.put("attributes", new TypedValue((Object)resultResult.getAttributes(), DataType.builder().mediaType(resultResult.getAttributesMediaType().orElse(MediaType.ANY)).build()));
            } else {
                stepResult.put("payload", result);
            }
            evaluationContext.define(step.getName().get(), TypedValue.of(stepResult));
        }
    }

    private void defineResultForNextEvaluationContext(EvaluationContext evaluationContext, Object result) {
        if (result instanceof Result) {
            Result resultResult = (Result)result;
            evaluationContext.define("payload", resultResult.getOutput());
            evaluationContext.define("attributes", new TypedValue((Object)resultResult.getAttributes(), DataType.builder().mediaType(resultResult.getAttributesMediaType().orElse(MediaType.ANY)).build()));
        } else {
            evaluationContext.define("payload", result);
        }
    }

    private Result collectResultFromEvaluationContext(EvaluationContext evaluationContext) {
        TypedValue tOutput = this.getTypedValue(evaluationContext, "payload");
        TypedValue tOutputAttributes = this.getTypedValue(evaluationContext, "attributes");
        Result.Builder builder = Result.builder();
        if (tOutputAttributes != null) {
            ((Optional)tOutputAttributes.getValue()).ifPresent(attributes -> builder.attributes(attributes));
            builder.attributesMediaType(tOutputAttributes.getDataType().getMediaType());
        }
        return builder.output((Object)tOutput).mediaType(tOutput.getDataType().getMediaType()).build();
    }

    private TypedValue getTypedValue(EvaluationContext evaluationContext, String variableName) {
        Object variable = evaluationContext.getVariables().get(variableName);
        if (variable == null) {
            return null;
        }
        if (!(variable instanceof TypedValue)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("'%s' variable from evaluation context should be a '%s', instead it is a '%s'. This is a probably a bug.", variableName, TypedValue.class.getName(), variable.getClass().getName())));
        }
        return (TypedValue)variable;
    }

    public static class Step {
        private final String name;
        private final DataExpression dataExpression;

        public Step(String name, DataExpression dataExpression) {
            this.name = name;
            this.dataExpression = dataExpression;
        }

        public Step(DataExpression dataExpression) {
            this(null, dataExpression);
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public DataExpression getDataExpression() {
            return this.dataExpression;
        }
    }
}

