/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import com.mulesoft.connectivity.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.queryparam.CommaRequestParameterFormatter;
import com.mulesoft.connectivity.rest.commons.api.operation.queryparam.MultimapRequestParameterFormatter;
import com.mulesoft.connectivity.rest.commons.api.operation.queryparam.RequestParameterFormatter;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRequestBuilder.class);
    public static final String PATH_PARAMETERS_NOT_USED_ERROR_TEMPLATE = "The request was not correctly built. Required URI parameters were not set. [%s]";
    public static final String NULL_URI_PARAMETER_ERROR_TEMPLATE = "URI Parameters are mandatory and its value cannot be null. Trying to assign a null value to the '%s' URI parameter.";
    private final String baseUri;
    private String path;
    private final HttpConstants.Method method;
    private String fullUri;
    private final Map<String, Object> headers = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Object> queryParams = new HashMap<String, Object>();
    private final HashMap<String, Object> uriParams = new HashMap();
    private TypedValue<InputStream> body = null;
    private StreamingType streamingType = StreamingType.AUTO;
    private ParameterArrayFormat queryParamFormat = ParameterArrayFormat.MULTIMAP;
    private HttpResponseInterceptorDescriptor httpResponseInterceptorDescriptor;
    private final RequestParameters customOperationParameters;

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method) {
        this(baseUri, path, method, null);
    }

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method, RequestParameters customParameters) {
        this.baseUri = baseUri;
        this.path = path;
        this.method = method;
        this.customOperationParameters = customParameters;
    }

    public String getUri() {
        return this.buildRequestUri();
    }

    public String getMethod() {
        return this.method.name();
    }

    public RestRequestBuilder addUriParam(String placeholderKey, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(NULL_URI_PARAMETER_ERROR_TEMPLATE, placeholderKey));
        }
        this.uriParams.put(placeholderKey, value);
        return this;
    }

    public RestRequestBuilder addHeader(String key, Object value) {
        if (value != null) {
            this.headers.put(key, value);
        }
        return this;
    }

    public RestRequestBuilder addQueryParam(String key, Object value) {
        if (value != null) {
            this.queryParams.put(key, value);
        }
        return this;
    }

    public void clearUriParams() {
        this.uriParams.clear();
    }

    public void clearQueryParams() {
        this.queryParams.clear();
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public Map<String, String> getUriParams() {
        return Collections.unmodifiableMap(ParameterArrayFormat.MULTIMAP.getFormatter().format(this.uriParams));
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParamFormat.getFormatter().format(this.queryParams).toImmutableMultiMap();
    }

    public MultiMap<String, String> getHeaders() {
        return ParameterArrayFormat.MULTIMAP.getFormatter().format(this.headers, false).toImmutableMultiMap();
    }

    public RestRequestBuilder setQueryParamFormat(ParameterArrayFormat queryParamFormat) {
        this.queryParamFormat = queryParamFormat;
        return this;
    }

    public RestRequestBuilder setBody(TypedValue<InputStream> body, StreamingType streamingType) {
        this.body = body;
        this.streamingType = streamingType;
        return this;
    }

    public RestRequestBuilder responseInterceptorDescriptor(HttpResponseInterceptorDescriptor httpResponseInterceptorDescriptor) {
        Objects.requireNonNull(httpResponseInterceptorDescriptor);
        this.httpResponseInterceptorDescriptor = httpResponseInterceptorDescriptor;
        return this;
    }

    public HttpResponseInterceptorDescriptor getResponseInterceptorDescriptor() {
        return this.httpResponseInterceptorDescriptor;
    }

    private HttpEntity getStreamingConfiguredHttpEntity(TypedValue<InputStream> body, StreamingType streamingType) {
        if (body != null) {
            byte[] bytes = null;
            if (streamingType.equals((Object)StreamingType.ALWAYS)) {
                this.headers.remove("Content-Length");
                this.headers.remove("Transfer-Encoding");
                this.addHeader("Transfer-Encoding", "chunked");
            } else if (streamingType.equals((Object)StreamingType.NEVER)) {
                bytes = this.setNeverStreamingContentLength(body);
            } else {
                this.setAutoContentLengthHeader(body);
            }
            this.inferContentTypeFromBody(body);
            if (body.getValue() != null) {
                if (bytes != null) {
                    return new ByteArrayHttpEntity(bytes);
                }
                return new InputStreamHttpEntity((InputStream)body.getValue());
            }
        }
        return null;
    }

    private void inferContentTypeFromBody(TypedValue<InputStream> body) {
        MediaType mediaType;
        if (!this.headers.containsKey("Content-Type") && (mediaType = body.getDataType().getMediaType()) != null && !mediaType.getPrimaryType().equals("*")) {
            this.addHeader("Content-Type", mediaType.toRfcString());
        }
    }

    private byte[] setNeverStreamingContentLength(TypedValue<InputStream> body) {
        String customLength = RestSdkUtils.stringValue(this.headers.get("Content-Length"));
        byte[] bytes = null;
        if (customLength == null) {
            if (body.getByteLength().isPresent()) {
                this.addHeader("Content-Length", body.getByteLength().getAsLong());
            } else if (body.getValue() != null) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)body.getValue()));
                this.addHeader("Content-Length", bytes.length);
            }
        }
        this.headers.remove("Transfer-Encoding");
        return bytes;
    }

    private void setAutoContentLengthHeader(TypedValue<InputStream> body) {
        MultiMap<String, String> headers = this.getHeaders();
        String customLength = RestSdkUtils.stringValue(headers.get((Object)"Content-Length"));
        boolean isChunked = "chunked".equals(headers.get((Object)"Transfer-Encoding"));
        if (body.getByteLength().isPresent()) {
            boolean addHeader = true;
            String length = RestSdkUtils.stringValue(body.getByteLength().getAsLong());
            if (customLength != null) {
                LOGGER.warn("Invoking URI {} with body of known length {}. However, a {} header with value {} was manually specified. Will proceed with the custom value.", new Object[]{this.getUri(), length, "Content-Length", customLength});
                addHeader = false;
            }
            if (isChunked) {
                LOGGER.debug("Invoking URI {} with a manually set {}: {} header, even though body is of known length {}. Skipping automatic addition of {} header", new Object[]{this.getUri(), "Transfer-Encoding", "chunked", length, "Content-Length"});
                addHeader = false;
            }
            if (addHeader) {
                this.addHeader("Content-Length", length);
            }
        } else if (customLength == null && !isChunked) {
            this.addHeader("Transfer-Encoding", "chunked");
        }
    }

    public HttpRequest build() {
        if (this.customOperationParameters != null) {
            MultiMap<String, String> customQueryParams = this.customOperationParameters.getCustomQueryParams();
            for (Object key : customQueryParams.keySet()) {
                this.addQueryParam((String)key, customQueryParams.getAll(key));
            }
            MultiMap<String, String> customHeaders = this.customOperationParameters.getCustomHeaders();
            for (String key : customHeaders.keySet()) {
                this.addHeader(key, customHeaders.getAll((Object)key));
            }
        }
        HttpEntity httpEntity = this.getStreamingConfiguredHttpEntity(this.body, this.streamingType);
        String requestUri = this.getUri();
        this.validateUri(requestUri);
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder((boolean)true).uri(requestUri).method(this.method).queryParams(this.getQueryParams()).headers(this.getHeaders());
        if (httpEntity != null) {
            builder.entity(httpEntity);
        }
        return builder.build();
    }

    private void validateUri(String requestUri) {
        if (requestUri.contains("{")) {
            throw new IllegalArgumentException(String.format(PATH_PARAMETERS_NOT_USED_ERROR_TEMPLATE, requestUri));
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFullUri(String fullUri) {
        this.fullUri = fullUri;
    }

    private String buildRequestUri() {
        if (RestSdkUtils.isNotBlank(this.fullUri)) {
            return this.fullUri;
        }
        String localPath = this.path;
        String localBaseUri = this.baseUri;
        boolean pathStartsWithSlash = localPath != null && localPath.startsWith("/");
        boolean baseEndsInSlash = localBaseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            localPath = localPath.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            localBaseUri = localBaseUri + '/';
        }
        localPath = this.applyUriParameters(localPath);
        if (localPath == null) {
            return localBaseUri;
        }
        return localBaseUri + localPath;
    }

    private String applyUriParameters(String path) {
        Map<String, String> effectiveUriParams = this.getUriParams();
        for (String key : effectiveUriParams.keySet()) {
            path = path.replace(String.format("{%s}", key), effectiveUriParams.get(key));
        }
        return path;
    }

    public static enum ParameterArrayFormat {
        MULTIMAP(new MultimapRequestParameterFormatter()),
        COMMA(new CommaRequestParameterFormatter());

        private final RequestParameterFormatter formatter;

        private ParameterArrayFormat(RequestParameterFormatter formatter) {
            this.formatter = formatter;
        }

        public RequestParameterFormatter getFormatter() {
            return this.formatter;
        }
    }
}

