/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamUtils.class);

    public static <K> Map<K, Object> resolveCursorProvider(Map<K, Object> map) {
        Map<K, Object> transformed;
        try {
            transformed = (Map)ClassUtils.instantiateClass(map.getClass(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            transformed = new LinkedHashMap();
        }
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            transformed.put(entry.getKey(), StreamUtils.resolveCursorProvider(value));
        }
        return transformed;
    }

    public static Object resolveCursorProvider(Object value) {
        if (value instanceof CursorStream && !((CursorStream)value).getProvider().isClosed()) {
            CursorStream cursorStream = (CursorStream)value;
            CursorProvider cursorProvider = cursorStream.getProvider();
            try {
                cursorStream.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing cursor stream", (Throwable)e);
            }
            return cursorProvider;
        }
        if (value instanceof InputStream) {
            return StreamingUtils.asCursorProvider((byte[])IOUtils.toByteArray((InputStream)((InputStream)value)));
        }
        if (value instanceof TypedValue) {
            return StreamUtils.resolveTypedValueCursorProvider((TypedValue)value);
        }
        return value;
    }

    private static TypedValue resolveTypedValueCursorProvider(TypedValue value) {
        Object resolvedValue = StreamUtils.resolveCursorProvider(value.getValue());
        return resolvedValue != value.getValue() ? new TypedValue(resolvedValue, value.getDataType()) : value;
    }
}

