/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor;

import static java.util.Objects.requireNonNull;

public class ExpressionHttpResponseInterceptorDescriptor extends HttpResponseInterceptorDescriptor {

  private String matchExpression;

  private String statusCodeExpression;
  private String reasonPhraseExpression;
  private String headersExpression;
  private String bodyExpression;

  public ExpressionHttpResponseInterceptorDescriptor(String matchExpression, String statusCodeExpression,
                                                     String reasonPhraseExpression, String headersExpression,
                                                     String bodyExpression) {
    this.matchExpression = requireNonNull(matchExpression, "matchExpression cannot be null");
    this.statusCodeExpression = statusCodeExpression;
    this.reasonPhraseExpression = reasonPhraseExpression;
    this.headersExpression = headersExpression;
    this.bodyExpression = bodyExpression;
  }

  @Override
  public void accept(HttpResponseInterceptorDescriptorVisitor visitor) {
    visitor.visit(this);
  }

  public String getMatchExpression() {
    return matchExpression;
  }

  public String getStatusCodeExpression() {
    return statusCodeExpression;
  }

  public String getReasonPhraseExpression() {
    return reasonPhraseExpression;
  }

  public String getHeadersExpression() {
    return headersExpression;
  }

  public String getBodyExpression() {
    return bodyExpression;
  }

}
