/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.isNotBlank;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.List;

import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;

public class ArrayHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof ArraySchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager,
                               ParsingContext parsingContext) {
    ArraySchema arraySchema = (ArraySchema) schema;

    if (arraySchema.getItemSchemas() != null && !arraySchema.getItemSchemas().isEmpty()) {
      final List<Schema> itemSchemas = arraySchema.getItemSchemas();
      final TupleTypeBuilder tupleType = root.tupleType();
      final String description = arraySchema.getDescription();
      if (isNotBlank(description)) {
        tupleType.description(description);
      }

      final String title = arraySchema.getTitle();
      if (isNotBlank(title)) {
        tupleType.label(title);
      }
      for (Schema itemSchema : itemSchemas) {
        tupleType.of(handlerManager.handle(itemSchema, parsingContext));
      }
      return tupleType;
    } else {

      final ArrayTypeBuilder arrayMetadataBuilder = root.arrayType();
      final String description = arraySchema.getDescription();
      if (isNotBlank(description)) {
        arrayMetadataBuilder.description(description);
      }

      final String title = arraySchema.getTitle();
      if (isNotBlank(title)) {
        arrayMetadataBuilder.label(title);
      }

      if (arraySchema.needsUniqueItems()) {
        arrayMetadataBuilder.uniques();
      }

      Integer min = null;
      Integer max = null;

      if (arraySchema.getMinItems() != null && arraySchema.getMinItems() > 0) {
        min = arraySchema.getMinItems();
      }

      if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() > 0) {
        max = arraySchema.getMaxItems();
      }

      if (min != null || max != null) {
        arrayMetadataBuilder.boundary(min, max);
      }

      final Schema arrayType = arraySchema.getAllItemSchema();
      if (arrayType != null) {
        arrayMetadataBuilder.of(handlerManager.handle(arrayType, parsingContext));
      } else {
        arrayMetadataBuilder.of().anyType();
      }

      final String id = arraySchema.getId();
      if (isNotBlank(id)) {
        arrayMetadataBuilder.id(id);
      }

      return arrayMetadataBuilder;
    }
  }
}
