/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class PageNumberPagingProvider
extends RestPagingProvider {
    private final String pageNumberParamName;
    private final String pageCountExpression;
    private int pageNumber;

    public PageNumberPagingProvider(String pageNumberParamName, String pageCountExpression, int initialPageNumber, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, String payloadExpression, MediaType defaultMediaType, Map<String, Object> parameterBindings, Map<String, Object> customParameterBindings, int responseTimeout) {
        super(requestFactory, expressionLanguage, payloadExpression, defaultMediaType, parameterBindings, customParameterBindings, responseTimeout);
        this.pageNumberParamName = pageNumberParamName;
        this.pageCountExpression = pageCountExpression;
        this.pageNumber = initialPageNumber;
    }

    @Override
    protected void configureRequest(RestRequestBuilder requestBuilder) {
        requestBuilder.addQueryParam(this.pageNumberParamName, this.pageNumber);
    }

    @Override
    protected void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, HttpResponseAttributes httpResponseAttributes) {
        if (this.pageCountExpression != null && this.pageNumber == this.extractPageCount(rawPage, httpResponseAttributes)) {
            this.stopPaging();
        } else {
            ++this.pageNumber;
        }
    }

    private Integer extractPageCount(TypedValue<String> rawPage, HttpResponseAttributes httpResponseAttributes) {
        Integer pageCount = (Integer)this.evaluate(rawPage, this.pageCountExpression, DataType.NUMBER, httpResponseAttributes).getValue();
        if (pageCount == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to extract pageCount from expression: %s", this.pageCountExpression)));
        }
        return pageCount;
    }
}

