/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception;

import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.CompositeHttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.ExpressionHttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptorVisitor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.PreconditionHttpResponseInterceptorDelegateDescriptor;
import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.interception.CompositeHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.internal.interception.expression.ExpressionHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.internal.interception.expression.PreconditionHttpResponseInterceptorDelegate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;

public class HttpResponseInterceptorFactory {
    public HttpResponseInterceptor newHttpResponseInterceptor(HttpResponseInterceptorDescriptor descriptor, MediaType defaultResponseMediaType, StreamingHelper streamingHelper, ExpressionLanguage expressionLanguage) {
        HttpResponseInterceptorFactoryVisitor httpResponseInterceptorFactoryVisitor = new HttpResponseInterceptorFactoryVisitor(defaultResponseMediaType, streamingHelper, expressionLanguage);
        descriptor.accept(httpResponseInterceptorFactoryVisitor);
        return httpResponseInterceptorFactoryVisitor.getHttpResponseInterceptor();
    }

    private class HttpResponseInterceptorFactoryVisitor
    implements HttpResponseInterceptorDescriptorVisitor {
        private HttpResponseInterceptor httpResponseInterceptor;
        private MediaType defaultResponseMediaType;
        private StreamingHelper streamingHelper;
        private ExpressionLanguage expressionLanguage;

        public HttpResponseInterceptorFactoryVisitor(MediaType defaultResponseMediaType, StreamingHelper streamingHelper, ExpressionLanguage expressionLanguage) {
            this.defaultResponseMediaType = Objects.requireNonNull(defaultResponseMediaType, "defaultResponseMediaType cannot be null");
            this.streamingHelper = streamingHelper;
            this.expressionLanguage = Objects.requireNonNull(expressionLanguage, "expressionLanguage cannot be null");
        }

        @Override
        public void visit(ExpressionHttpResponseInterceptorDescriptor descriptor) {
            ExpressionHttpResponseInterceptor.ExpressionHttpResponseInterceptorBuilder builder = ExpressionHttpResponseInterceptor.builder().matchExpression(descriptor.getMatchExpression()).defaultResponseMediaType(this.defaultResponseMediaType);
            Optional.ofNullable(descriptor.getStatusCodeExpression()).ifPresent(expression -> builder.statusCodeExpression((String)expression));
            Optional.ofNullable(descriptor.getReasonPhraseExpression()).ifPresent(expression -> builder.reasonPhraseExpression((String)expression));
            Optional.ofNullable(descriptor.getBodyExpression()).ifPresent(expression -> builder.bodyExpression((String)expression));
            Optional.ofNullable(descriptor.getHeadersExpression()).ifPresent(expression -> builder.headersExpression((String)expression));
            Optional.ofNullable(this.streamingHelper).ifPresent(expression -> builder.streamingHelper(this.streamingHelper));
            builder.expressionLanguage(this.expressionLanguage);
            this.httpResponseInterceptor = builder.build();
        }

        @Override
        public void visit(PreconditionHttpResponseInterceptorDelegateDescriptor descriptor) {
            HttpResponseInterceptorFactoryVisitor delegateVisitor = new HttpResponseInterceptorFactoryVisitor(this.defaultResponseMediaType, this.streamingHelper, this.expressionLanguage);
            descriptor.getDelegateDescriptor().accept(delegateVisitor);
            this.httpResponseInterceptor = new PreconditionHttpResponseInterceptorDelegate(statusCode -> descriptor.getPrecondition().match(statusCode), delegateVisitor.getHttpResponseInterceptor());
        }

        @Override
        public void visit(CompositeHttpResponseInterceptorDescriptor descriptor) {
            List<HttpResponseInterceptor> httpResponseInterceptors = descriptor.getHttpResponseInterceptorDescriptors().stream().map(itemDescriptor -> {
                HttpResponseInterceptorFactoryVisitor delegateVisitor = new HttpResponseInterceptorFactoryVisitor(this.defaultResponseMediaType, this.streamingHelper, this.expressionLanguage);
                itemDescriptor.accept(delegateVisitor);
                return delegateVisitor.getHttpResponseInterceptor();
            }).collect(Collectors.toList());
            this.httpResponseInterceptor = new CompositeHttpResponseInterceptor(httpResponseInterceptors);
        }

        public HttpResponseInterceptor getHttpResponseInterceptor() {
            return this.httpResponseInterceptor;
        }
    }
}

