/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception.expression;

import com.mulesoft.connectivity.rest.commons.api.interception.HttpRequest;
import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.interception.expression.BaseExpressionHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.internal.interception.model.HttpEntityCursorStreamProviderBased;
import com.mulesoft.connectivity.rest.commons.internal.interception.model.RepeatableHttpResponse;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionHttpResponseInterceptor
extends BaseExpressionHttpResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionHttpResponseInterceptor.class);
    private String matchExpression;
    private String statusCodeExpression;
    private String reasonPhraseExpression;
    private String headersExpression;
    private String bodyExpression;

    private ExpressionHttpResponseInterceptor(String matchExpression, String statusCodeExpression, String reasonPhraseExpression, String headersExpression, String bodyExpression, MediaType defaultResponseMediaType, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper) {
        super(defaultResponseMediaType, expressionLanguage, streamingHelper);
        Objects.requireNonNull(matchExpression);
        this.matchExpression = matchExpression;
        this.statusCodeExpression = statusCodeExpression;
        this.reasonPhraseExpression = reasonPhraseExpression;
        this.headersExpression = headersExpression;
        this.bodyExpression = bodyExpression;
    }

    private boolean match(ExpressionLanguageSession session) {
        return ExpressionHttpResponseInterceptor.resolveBoolean(this.evaluate(this.matchExpression, session, DataType.OBJECT).getValue(), this.matchExpression);
    }

    private static boolean resolveBoolean(Object result, String expression) {
        if (result == null) {
            return false;
        }
        Object value = result;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (value.toString().equalsIgnoreCase("false")) {
                return false;
            }
            if (result.toString().equalsIgnoreCase("true")) {
                return true;
            }
            LOGGER.warn("Expression: '" + expression + "', returned an non-boolean result: '" + result + "'. Returning: false");
            return false;
        }
        LOGGER.warn("Expression: " + expression + ", returned an non-boolean result: '" + result + "'. Returning: false");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected RepeatableHttpResponse doIntercept(HttpRequest httpRequest, RepeatableHttpResponse repeatableHttpResponse, ExpressionLanguageSession session, BindingContext bindingContext, ExpressionLanguage expressionLanguage) {
        HttpEntity entity;
        if (!this.match(session)) return repeatableHttpResponse;
        int statusCode = (Integer)this.getStatusCodeExpression().map(expression -> this.evaluate((String)expression, session, DataType.fromType(Integer.class)).getValue()).orElseGet(() -> repeatableHttpResponse.getStatusCode());
        String reasonPhrase = (String)this.getReasonPhraseExpression().map(expression -> this.evaluate((String)expression, session, DataType.fromType(String.class)).getValue()).orElseGet(() -> repeatableHttpResponse.getReasonPhrase());
        MultiMap<String, String> headers = (MultiMap<String, String>)this.getHeadersExpression().map(expression -> this.evaluate(this.headersExpression, session, DataType.fromType(MultiMap.class)).getValue()).orElseGet(() -> repeatableHttpResponse.getHeaders());
        if (this.getBodyExpression().isPresent()) {
            String bodyExpression = this.getBodyExpression().get();
            TypedValue<Object> transformedBody = this.evaluateBodyExpression(bodyExpression, repeatableHttpResponse, session, bindingContext, expressionLanguage);
            if (!(transformedBody.getValue() instanceof CursorStreamProvider)) throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"HTTP response interceptor expression for body has generated a non recognizable output: '%s'. This is probably a bug.", (Object[])new Object[]{transformedBody.getValue().getClass().getName()}));
            CursorStreamProvider cursorStreamProvider = (CursorStreamProvider)transformedBody.getValue();
            if (cursorStreamProvider != repeatableHttpResponse.getRepeatableEntity().getCursorStreamProvider()) {
                entity = new HttpEntityCursorStreamProviderBased(cursorStreamProvider, repeatableHttpResponse.getEntity().getBytesLength().isPresent() ? transformedBody.getByteLength() : OptionalLong.empty());
                headers = this.updateContentLengthHeader(headers, transformedBody.getByteLength());
                repeatableHttpResponse.close();
                return RepeatableHttpResponse.newRepeatableHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).reasonPhrase(reasonPhrase).entity(entity)).headers((MultiMap)headers)).build(), this.streamingHelper);
            } else {
                entity = repeatableHttpResponse.getRepeatableEntity();
            }
            return RepeatableHttpResponse.newRepeatableHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).reasonPhrase(reasonPhrase).entity(entity)).headers((MultiMap)headers)).build(), this.streamingHelper);
        } else {
            entity = repeatableHttpResponse.getEntity();
        }
        return RepeatableHttpResponse.newRepeatableHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).reasonPhrase(reasonPhrase).entity(entity)).headers((MultiMap)headers)).build(), this.streamingHelper);
    }

    private TypedValue<Object> evaluateBodyExpression(String bodyExpression, HttpResponse httpResponse, ExpressionLanguageSession session, BindingContext bindingContext, ExpressionLanguage expressionLanguage) {
        CompiledExpression compile = expressionLanguage.compile(bodyExpression, bindingContext);
        MediaType mediaType = compile.outputType().orElse(this.getMediaType(httpResponse));
        return session.evaluate(bodyExpression, DataType.builder().mediaType(mediaType).charset(RestSdkUtils.resolveCharset(Optional.empty(), mediaType)).build());
    }

    private MultiMap<String, String> updateContentLengthHeader(MultiMap<String, String> headers, OptionalLong length) {
        if (!headers.containsKey((Object)"Content-Length") && !headers.containsKey((Object)"Content-Length".toLowerCase())) {
            return headers;
        }
        MultiMap.StringMultiMap modifiedHeaders = new MultiMap.StringMultiMap();
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase("Content-Length")) continue;
            modifiedHeaders.put((Object)key, (Collection)headers.getAll((Object)key));
        }
        modifiedHeaders.put((Object)(HttpServerProperties.PRESERVE_HEADER_CASE ? "Content-Length" : "Content-Length".toLowerCase()), (Object)String.valueOf(length.getAsLong()));
        return modifiedHeaders;
    }

    private Optional<String> getBodyExpression() {
        return Optional.ofNullable(this.bodyExpression);
    }

    private Optional<String> getHeadersExpression() {
        return Optional.ofNullable(this.headersExpression);
    }

    private Optional<String> getStatusCodeExpression() {
        return Optional.ofNullable(this.statusCodeExpression);
    }

    private Optional<String> getReasonPhraseExpression() {
        return Optional.ofNullable(this.reasonPhraseExpression);
    }

    public static ExpressionHttpResponseInterceptorBuilder builder() {
        return new ExpressionHttpResponseInterceptorBuilder();
    }

    public static class ExpressionHttpResponseInterceptorBuilder {
        private String matchExpression;
        protected String statusCodeExpression;
        protected String reasonPhraseExpression;
        protected String headersExpression;
        protected String bodyExpression;
        protected MediaType defaultResponseMediaType;
        protected ExpressionLanguage expressionLanguage;
        private StreamingHelper streamingHelper;

        public ExpressionHttpResponseInterceptorBuilder matchExpression(String matchExpression) {
            Objects.requireNonNull(matchExpression);
            this.matchExpression = matchExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder statusCodeExpression(String statusCodeExpression) {
            Objects.requireNonNull(statusCodeExpression);
            this.statusCodeExpression = statusCodeExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder reasonPhraseExpression(String reasonPhraseExpression) {
            Objects.requireNonNull(reasonPhraseExpression);
            this.reasonPhraseExpression = reasonPhraseExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder headersExpression(String headersExpression) {
            Objects.requireNonNull(headersExpression);
            this.headersExpression = headersExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder bodyExpression(String bodyExpression) {
            Objects.requireNonNull(bodyExpression);
            this.bodyExpression = bodyExpression;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder defaultResponseMediaType(MediaType defaultResponseMediaType) {
            Objects.requireNonNull(defaultResponseMediaType);
            this.defaultResponseMediaType = defaultResponseMediaType;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder expressionLanguage(ExpressionLanguage expressionLanguage) {
            Objects.requireNonNull(expressionLanguage);
            this.expressionLanguage = expressionLanguage;
            return this;
        }

        public ExpressionHttpResponseInterceptorBuilder streamingHelper(StreamingHelper streamingHelper) {
            Objects.requireNonNull(streamingHelper);
            this.streamingHelper = streamingHelper;
            return this;
        }

        public ExpressionHttpResponseInterceptor build() {
            return new ExpressionHttpResponseInterceptor(this.matchExpression, this.statusCodeExpression, this.reasonPhraseExpression, this.headersExpression, this.bodyExpression, this.defaultResponseMediaType, this.expressionLanguage, this.streamingHelper);
        }
    }
}

