/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestSchemaHelper;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.everit.json.schema.Schema;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;

public class RestJsonTypeLoader
implements TypeLoader {
    private JsonSchemaLoader jsonSchemaLoader;
    private MetadataFormat metadataFormat;

    public RestJsonTypeLoader(File schemaFile, MetadataFormat metadataFormat) {
        this.jsonSchemaLoader = new JsonSchemaFileLoader(schemaFile);
        this.metadataFormat = metadataFormat;
    }

    public RestJsonTypeLoader(String schemaData, MetadataFormat metadataFormat) {
        this(schemaData, null, metadataFormat);
    }

    public RestJsonTypeLoader(String schemaData, URI baseURI, MetadataFormat metadataFormat) {
        this.jsonSchemaLoader = new JsonSchemaStringLoader(schemaData, baseURI);
        this.metadataFormat = metadataFormat;
    }

    private JsonSchemaLoader getJsonSchemaLoader() {
        return this.jsonSchemaLoader;
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    public Optional<MetadataType> load(String identifier, String typeAlias) {
        Schema jsonSchema = this.getJsonSchemaLoader().loadSchema();
        TypeBuilder<?> typeBuilder = this.createRestHandlerManager().handle(jsonSchema, new ParsingContext());
        MetadataTypeUtils.addTypeAlias(typeBuilder, (String)typeAlias);
        return Optional.of(typeBuilder.build());
    }

    protected RestHandlerManager createRestHandlerManager() {
        return new RestHandlerManager(this.metadataFormat);
    }

    private static class JsonSchemaStringLoader
    implements JsonSchemaLoader {
        private final URI baseURI;
        private String schemaData;

        public JsonSchemaStringLoader(String schemaData, URI baseURI) {
            this.schemaData = schemaData;
            this.baseURI = baseURI;
        }

        @Override
        public Schema loadSchema() {
            JSONObject rawSchema = new JSONObject(new JSONTokener(this.schemaData));
            return RestSchemaHelper.generateSchema(rawSchema, this.baseURI);
        }
    }

    private static class JsonSchemaFileLoader
    implements JsonSchemaLoader {
        private File schemaFile;

        public JsonSchemaFileLoader(File schemaFile) {
            this.schemaFile = schemaFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Schema loadSchema() {
            try (FileInputStream inputStream = new FileInputStream(this.schemaFile);){
                JSONObject rawSchema = new JSONObject(new JSONTokener((InputStream)inputStream));
                Schema schema = RestSchemaHelper.generateSchema(rawSchema, this.schemaFile.toURI());
                return schema;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface JsonSchemaLoader {
        public Schema loadSchema();
    }
}

