/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.DataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.HttpRequestDataExpressionBindingBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpressionBinding;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.metadata.MediaType;

public class HttpRequestDataExpressionBuilder
implements DataExpressionBuilder<HttpRequestDataExpression> {
    private String path;
    private String method;
    private String outputMediaType;
    private HttpRequestDataExpressionBindingBuilder httpRequestDataExpressionBindingBuilder = new HttpRequestDataExpressionBindingBuilder();

    public HttpRequestDataExpressionBuilder path(String path) {
        this.path = path;
        return this;
    }

    public HttpRequestDataExpressionBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestDataExpressionBuilder outputMediaType(String outputMediaType) {
        this.outputMediaType = outputMediaType;
        return this;
    }

    public HttpRequestDataExpressionBuilder bindings(Consumer<HttpRequestDataExpressionBindingBuilder> consumer) {
        consumer.accept(this.httpRequestDataExpressionBindingBuilder);
        return this;
    }

    private String buildPath() {
        return Optional.ofNullable(this.path).orElse("");
    }

    private String buildMethod() {
        if (this.method == null) {
            throw new IllegalStateException("Method not provided");
        }
        return this.method;
    }

    private MediaType buildOutputMediaType() {
        if (this.outputMediaType != null) {
            return MediaType.parse((String)this.outputMediaType);
        }
        return MediaType.APPLICATION_JSON;
    }

    private HttpRequestDataExpressionBinding buildHttpRequestDataExpressionBinding() {
        return this.httpRequestDataExpressionBindingBuilder.build();
    }

    @Override
    public HttpRequestDataExpression build() {
        return new HttpRequestDataExpression(this.buildPath(), this.buildMethod(), this.buildOutputMediaType(), this.buildHttpRequestDataExpressionBinding());
    }
}

