/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestSdkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestSdkUtils.class);

    private RestSdkUtils() {
    }

    public static void closeAndRelease(CursorProvider<?> cursorProvider) {
        cursorProvider.close();
        cursorProvider.releaseResources();
    }

    public static void closeStream(Object stream) {
        if (stream instanceof CursorProvider) {
            RestSdkUtils.closeAndRelease((CursorProvider)stream);
        } else if (stream instanceof InputStream) {
            IOUtils.closeQuietly((Closeable)((InputStream)stream));
        }
    }

    public static TypedValue<String> consumeStringAndClose(Object stream, MediaType targetMediaType, Charset targetCharset) {
        return RestSdkUtils.consumeStringTransformAndClose(stream, targetCharset, targetMediaType, targetCharset);
    }

    public static TypedValue<InputStream> consumeToOfflineStreamAndClose(Object stream, MediaType targetMediaType, Charset targetCharset) {
        TypedValue<String> string = RestSdkUtils.consumeStringAndClose(stream, targetMediaType, targetCharset);
        return new TypedValue((Object)new ByteArrayInputStream(((String)string.getValue()).getBytes()), DataType.builder().type(InputStream.class).mediaType(string.getDataType().getMediaType()).build(), string.getByteLength());
    }

    public static TypedValue<String> consumeStringTransformAndClose(Object stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        Either content;
        if (stream == null) {
            return RestSdkUtils.toTypedValue("", targetMediaType, targetCharset);
        }
        if (stream instanceof String) {
            return RestSdkUtils.toTypedValue((String)stream, targetMediaType, targetCharset);
        }
        if (stream instanceof CursorStreamProvider) {
            content = Either.left((Object)((CursorStreamProvider)stream));
        } else if (stream instanceof InputStream) {
            content = Either.right((Object)((InputStream)stream));
        } else {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        return (TypedValue)content.reduce(provider -> {
            try {
                TypedValue<String> typedValue = RestSdkUtils.doConsumeAndClose((InputStream)provider.openCursor(), sourceCharset, targetMediaType, targetCharset);
                return typedValue;
            }
            finally {
                RestSdkUtils.closeAndRelease(provider);
            }
        }, in -> RestSdkUtils.doConsumeAndClose(in, sourceCharset, targetMediaType, targetCharset));
    }

    public static MediaType getMediaType(HttpResponse response, MediaType defaultResponseMediaType) {
        MediaType contentType;
        block3: {
            contentType = defaultResponseMediaType;
            String responseContentType = (String)response.getHeaders().get((Object)"Content-Type");
            if (responseContentType != null) {
                try {
                    contentType = MediaType.parse((String)responseContentType);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug(String.format("Response Content-Type '%s' could not be parsed to a valid Media Type. Will ignore", responseContentType), (Throwable)e);
                }
            }
        }
        return contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedValue<String> doConsumeAndClose(InputStream stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        try {
            TypedValue<String> typedValue = RestSdkUtils.toTypedValue(IOUtils.toString((InputStream)stream, (Charset)sourceCharset), targetMediaType, targetCharset);
            return typedValue;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public static TypedValue<String> toTypedValue(String value, MediaType mediaType, Charset encoding) {
        return new TypedValue((Object)value, DataType.builder().mediaType(mediaType).charset(encoding).build());
    }

    public static boolean containsIgnoreCase(String value, String predicate) {
        if (value == null || predicate == null) {
            return false;
        }
        return value.toLowerCase().contains(predicate.toLowerCase());
    }

    public static boolean isNotBlank(String v) {
        return !RestSdkUtils.isBlank(v);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSchema(ClassLoader classLoader, String schemaPath) {
        try (InputStream in = classLoader.getResourceAsStream(schemaPath);){
            if (in == null) {
                throw new IllegalArgumentException("Could not find schema at " + schemaPath);
            }
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MetadataType loadXmlSchema(ClassLoader classLoader, String schemaPath, String qName) {
        schemaPath = RestSdkUtils.makeRelativePath(schemaPath);
        String schemaContent = RestSdkUtils.readSchema(classLoader, schemaPath);
        URL schemaURL = classLoader.getResource(schemaPath);
        SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(schemaURL.toString(), (InputStream)new ByteArrayInputStream(schemaContent.getBytes()));
        Optional metadataType = new XmlTypeLoader(schemaCollector).load(qName);
        if (!metadataType.isPresent()) {
            throw new RuntimeException("Could not load XML Schema " + schemaPath + " QName:" + qName);
        }
        return (MetadataType)metadataType.get();
    }

    public static MetadataType loadJsonSchema(Function<String, TypeLoader> typeLoaderFactory, ClassLoader classLoader, String schemaPath) {
        String schemaContent = RestSdkUtils.readSchema(classLoader, schemaPath = RestSdkUtils.makeRelativePath(schemaPath));
        Optional optionalMetadataType = typeLoaderFactory.apply(schemaContent).load(null);
        if (!optionalMetadataType.isPresent()) {
            throw new RuntimeException("Could not load Json Schema " + schemaPath);
        }
        return (MetadataType)optionalMetadataType.get();
    }

    private static String makeRelativePath(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static List<TypedValue<String>> toList(Iterator<TypedValue<?>> iterator, MediaType mediaType, MediaType defaultMediaType) {
        ArrayList<TypedValue<String>> list = new ArrayList<TypedValue<String>>();
        Charset encoding = RestSdkUtils.resolveCharset(Optional.of(mediaType), defaultMediaType);
        iterator.forEachRemaining(v -> {
            TypedValue<String> stringTypedValue = v.getDataType().getMediaType().getCharset().isPresent() && ((Charset)v.getDataType().getMediaType().getCharset().get()).equals(encoding) ? RestSdkUtils.consumeStringAndClose(v.getValue(), mediaType, encoding) : RestSdkUtils.consumeStringTransformAndClose(v.getValue(), (Charset)v.getDataType().getMediaType().getCharset().get(), mediaType, encoding);
            list.add(stringTypedValue);
        });
        return list;
    }

    public static Charset resolveCharset(Optional<MediaType> mediaType, MediaType defaultMediaType) {
        return mediaType.flatMap(MediaType::getCharset).orElseGet(() -> defaultMediaType.getCharset().orElse(Charset.defaultCharset()));
    }

    public static TypedValue<?> getTypedValueOrNull(Object o) {
        return o != null ? TypedValue.of((Object)o) : null;
    }

    public static String stringValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Integer | o instanceof Long | o instanceof Double) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(o);
        }
        return String.valueOf(o);
    }
}

