/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.Schema;

public class BooleanHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof BooleanSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager,
                               ParsingContext parsingContext) {
    return root.booleanType();
  }
}
