/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import java.util.ArrayList;
import java.util.Collection;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;

public class CombinedHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof CombinedSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        CombinedSchema combinedSchema = (CombinedSchema)schema;
        Collection subschemas = combinedSchema.getSubschemas();
        if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
            UnionTypeBuilder unionType = root.unionType();
            for (Schema subschema : subschemas) {
                unionType.of(handlerManager.handle(subschema, parsingContext));
            }
            return unionType;
        }
        if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
            IntersectionTypeBuilder typeBuilder;
            ArrayList<Schema> uniqueSubschemas = new ArrayList<Schema>();
            if (subschemas.size() == 2) {
                boolean enumSchemaPresent = subschemas.stream().anyMatch(currentSubschema -> currentSubschema instanceof EnumSchema);
                boolean stringSchemaPresent = subschemas.stream().anyMatch(currentSubschema -> currentSubschema instanceof StringSchema);
                for (Schema subschema : subschemas) {
                    if ((!enumSchemaPresent || !stringSchemaPresent || !(subschema instanceof EnumSchema)) && (!enumSchemaPresent || stringSchemaPresent || subschema instanceof EnumSchema)) continue;
                    uniqueSubschemas.add(subschema);
                }
                if (uniqueSubschemas.isEmpty()) {
                    uniqueSubschemas.addAll(subschemas);
                }
            } else {
                uniqueSubschemas.addAll(subschemas);
            }
            if (uniqueSubschemas.size() == 1) {
                typeBuilder = handlerManager.handle((Schema)uniqueSubschemas.iterator().next(), parsingContext);
            } else if (uniqueSubschemas.size() == 0) {
                typeBuilder = root.anyType();
            } else {
                IntersectionTypeBuilder intersectionType = root.intersectionType();
                for (Schema subschema : uniqueSubschemas) {
                    intersectionType.of(handlerManager.handle(subschema, parsingContext));
                }
                typeBuilder = intersectionType;
            }
            return typeBuilder;
        }
        return root.anyType();
    }
}

