/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class RestObjectHandler
implements SchemaHandler {
    public static final String PROPERTY_ORDER = "propertyOrder";
    public static final String CUSTOM_JSON_PROPERTY_PREFIX = "x-";

    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ObjectSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        String id;
        String title;
        ObjectSchema objectSchema = (ObjectSchema)schema;
        ObjectTypeBuilder objectMetadataBuilder = root.objectType().ordered(true);
        parsingContext.registerBuilder((Schema)objectSchema, (TypeBuilder<?>)objectMetadataBuilder);
        String description = objectSchema.getDescription();
        if (RestSdkUtils.isNotBlank(description)) {
            objectMetadataBuilder.description(description);
        }
        if (RestSdkUtils.isNotBlank(title = objectSchema.getTitle())) {
            objectMetadataBuilder.label(title);
        }
        if (RestSdkUtils.isNotBlank(id = objectSchema.getId())) {
            objectMetadataBuilder.id(id);
        }
        List<Map.Entry<String, Schema>> orderedProperties = this.getOrderedProperties(objectSchema);
        List requiredProperties = objectSchema.getRequiredProperties();
        for (Map.Entry<String, Schema> property : orderedProperties) {
            String fieldTitle;
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField().key(property.getKey());
            field.required(requiredProperties.contains(property.getKey()));
            Schema value = property.getValue();
            field.value(handlerManager.handle(value, parsingContext));
            String fieldDescription = value.getDescription();
            if (RestSdkUtils.isNotBlank(fieldDescription)) {
                field.description(fieldDescription);
            }
            if (!RestSdkUtils.isNotBlank(fieldTitle = value.getTitle())) continue;
            field.label(fieldTitle);
        }
        Map patternProperties = objectSchema.getPatternProperties();
        Collection entries = patternProperties.entrySet().stream().sorted(Comparator.comparing(o -> ((Pattern)o.getKey()).toString())).collect(Collectors.toList());
        for (Map.Entry patternSchemaEntry : entries) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField();
            field.key((Pattern)patternSchemaEntry.getKey());
            Schema value = (Schema)patternSchemaEntry.getValue();
            field.value(handlerManager.handle(value, parsingContext));
        }
        if (objectSchema.permitsAdditionalProperties()) {
            objectMetadataBuilder.openWith(handlerManager.handle(objectSchema.getSchemaOfAdditionalProperties(), parsingContext));
        }
        return objectMetadataBuilder;
    }

    private List<Map.Entry<String, Schema>> getOrderedProperties(ObjectSchema objectSchema) {
        ArrayList<?> propertyOrderArray = this.getPropertyOrder(objectSchema);
        HashMap propertySchemas = new HashMap(objectSchema.getPropertySchemas());
        if (propertyOrderArray == null) {
            return new ArrayList<Map.Entry<String, Schema>>(propertySchemas.entrySet());
        }
        ArrayList<Map.Entry<String, Schema>> result = new ArrayList<Map.Entry<String, Schema>>();
        for (Object propertyOrderItem : propertyOrderArray) {
            String key;
            Schema schema;
            if (!(propertyOrderItem instanceof String) || (schema = (Schema)propertySchemas.get(key = (String)propertyOrderItem)) == null) continue;
            propertySchemas.remove(key);
            result.add(new AbstractMap.SimpleEntry<String, Schema>(key, schema));
        }
        result.addAll(propertySchemas.entrySet());
        return result;
    }

    private ArrayList<?> getPropertyOrder(ObjectSchema objectSchema) {
        ArrayList<?> propertyOrder = this.getPropertyOrder(objectSchema, PROPERTY_ORDER);
        if (propertyOrder == null) {
            propertyOrder = this.getPropertyOrder(objectSchema, "x-propertyOrder");
        }
        return propertyOrder;
    }

    private ArrayList<?> getPropertyOrder(ObjectSchema objectSchema, String propertyName) {
        Object propertyOrderObject;
        if (objectSchema.getUnprocessedProperties().containsKey(propertyName) && (propertyOrderObject = objectSchema.getUnprocessedProperties().get(propertyName)) instanceof ArrayList) {
            return (ArrayList)propertyOrderObject;
        }
        return null;
    }
}

