/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LinkHeaderUtils {
    private static final String DELIM_LINKS = ",";
    private static final String DELIM_LINK_PARAM = ";";
    private static final String META_REL = "rel";

    public static Map<String, String> buildLinkHeaderMap(String linkHeader) {
        String[] links;
        if (RestSdkUtils.isBlank(linkHeader)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String link : links = linkHeader.split(DELIM_LINKS)) {
            String linkPart;
            String[] segments = link.split(DELIM_LINK_PARAM);
            if (segments.length < 2 || !(linkPart = segments[0].trim()).startsWith("<") || !linkPart.endsWith(">")) continue;
            linkPart = linkPart.substring(1, linkPart.length() - 1);
            for (int i = 1; i < segments.length; ++i) {
                String[] rel = segments[i].trim().split("=");
                if (rel.length < 2 || !META_REL.equals(rel[0])) continue;
                String relValue = rel[1];
                if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
                    relValue = relValue.substring(1, relValue.length() - 1);
                }
                result.put(relValue, linkPart);
            }
        }
        return result;
    }
}

