/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.resolving.InputStaticTypeResolver;

/**
 * Base class for {@link InputStaticTypeResolver} implementations that dynamically load a schema.
 *
 * @since 1.0
 */
public abstract class SchemaInputMetadataResolver extends InputStaticTypeResolver {

  @Override
  public String getResolverName() {
    return getClass().getName();
  }

  /**
   * Absolute path to the schema between the context of the owning connector. This path will be read using the
   * {@link Class#getResourceAsStream(String)} method
   *
   * @return the schema path inside the connector
   */
  protected abstract String getSchemaPath();

  /**
   * Parses the given {@code schema} and transforms it to a {@link MetadataType}
   * 
   * @param schema the schema to parse
   * @return a {@link MetadataType}
   */
  protected abstract MetadataType loadSchema(String schema);

  @Override
  public MetadataType getStaticMetadata() {
    return loadSchema(getSchemaPath());
  }
}
