/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import static com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader.JSON;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Arrays;
import java.util.List;

import org.everit.json.schema.Schema;

/**
 * This class is a copy of {@link org.mule.metadata.json.api.handler.HandlerManager} where the implementation of ObjectHandler is
 * overridden with a custom one.
 */
public class RestHandlerManager {

  private List<? extends SchemaHandler> handlers =
      Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(),
                    new EnumHandler(),
                    new NullHandler(), new NumberHandler(), new RestObjectHandler(), new ReferenceHandler(),
                    new StringHandler());

  public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
    if (parsingContext.isAlreadyBuild(schema)) {
      return parsingContext.getBuilder(schema).get();
    } else {
      for (SchemaHandler handler : handlers) {
        if (handler.handles(schema)) {
          return handler.handle(schema, BaseTypeBuilder.create(JSON), this, parsingContext);
        }
      }
      // If no type was detected we just generate any
      return BaseTypeBuilder.create(JSON).anyType();
    }
  }
}
