/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.common;

/**
 * An element that can be evaluated in a given context and generate a result.
 *
 * @since 1.0
 */
public interface Evaluable {

  /**
   * Evaluates this element in a given context and produces a result.
   *
   * @param evaluationContext The context where the evaluation will be made.
   * @return The result of evaluating this element in the given context.
   */
  Object evaluate(EvaluationContext evaluationContext);
}
