/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.sampledata;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.toList;
import static com.mulesoft.connectivity.rest.commons.internal.util.SplitPayloadUtils.split;
import static java.lang.Math.min;
import static org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.sdk.api.runtime.operation.Result;

import java.util.Iterator;
import java.util.List;

/**
 * A base implementation of Sample Data for paged operations.
 *
 * @since 1.0
 */
public abstract class PagedRestSampleDataProvider extends BaseRestSampleDataProvider<List<TypedValue<String>>, Void> {

  public static final int MAX_RESULTS = 5;

  @Override
  protected Result<List<TypedValue<String>>, Void> transformOutputTypedValueResult(Result<TypedValue<List<TypedValue<String>>>, Void> output) {
    TypedValue<List<TypedValue<String>>> payload = output.getOutput();

    Iterator<TypedValue<?>> split = split(expressionLanguage, payload);

    List<TypedValue<String>> typedValues = toList(split, payload.getDataType().getMediaType(), APPLICATION_JSON);

    typedValues = typedValues.subList(0, min(typedValues.size(), MAX_RESULTS));

    return Result.<List<TypedValue<String>>, Void>builder().output(typedValues).build();
  }

}
