/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;

/**
 * A factory for evaluation context builders. Allows to build an evaluation context builder for an operation or a trigger.
 *
 * @since 1.0
 */
public class EvaluationContextBuilderFactory {

  private final EvaluationContext globalEvaluationContext;

  public EvaluationContextBuilderFactory(EvaluationContext globalEvaluationContext) {
    this.globalEvaluationContext = globalEvaluationContext;
  }

  public TriggerEvaluationContextBuilder triggerContextBuilder() {
    return new TriggerEvaluationContextBuilder(globalEvaluationContext);
  }

  public OperationEvaluationContextBuilder operationContextBuilder() {
    return new OperationEvaluationContextBuilder(globalEvaluationContext);
  }

  public EvaluationContextBuilder emptyContextBuilder() {
    return new EmptyEvaluationContextBuilder(globalEvaluationContext);
  }
}
