/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpressionBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.HttpConstants;

public class HttpRequestDataExpression
implements DataExpression {
    private final String path;
    private final String method;
    private final HttpRequestDataExpressionBinding bindings;

    public HttpRequestDataExpression(String path, String method, HttpRequestDataExpressionBinding bindings) {
        this.path = path;
        this.method = method;
        this.bindings = bindings;
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        RestConfiguration configuration = (RestConfiguration)evaluationContext.resolveProperty("PROPERTY_CONFIGURATION");
        RestConnection connection = (RestConnection)evaluationContext.resolveProperty("PROPERTY_CONNECTION");
        RestRequestBuilder restRequestBuilder = this.getRestRequestBuilder(evaluationContext);
        return RequestStreamingUtils.doRequestAndConsumeString(connection, configuration, restRequestBuilder, this.getDefaultResponseMediaType());
    }

    private MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    private String getPathTemplate() {
        return this.path;
    }

    private Optional<HttpRequestDataExpressionBinding> getBindings() {
        return Optional.ofNullable(this.bindings);
    }

    private RestRequestBuilder getRestRequestBuilder(EvaluationContext evaluationContext) {
        RestConfiguration configuration = (RestConfiguration)evaluationContext.resolveProperty("PROPERTY_CONFIGURATION");
        RestConnection connection = (RestConnection)evaluationContext.resolveProperty("PROPERTY_CONNECTION");
        RestRequestBuilder restRequestBuilder = new RestRequestBuilder(connection.getBaseUri(), this.getPathTemplate(), HttpConstants.Method.valueOf((String)this.method.toUpperCase()));
        this.addUriParams(evaluationContext, restRequestBuilder);
        this.getBindings().ifPresent(httpRequestDataExpressionBinding -> {
            httpRequestDataExpressionBinding.getHeaders().forEach(header -> restRequestBuilder.addHeader(header.getName(), this.getParameterValue(header.getValue(), evaluationContext)));
            httpRequestDataExpressionBinding.getQueryParameters().forEach(queryParameter -> restRequestBuilder.addQueryParam(queryParameter.getName(), this.getParameterValue(queryParameter.getValue(), evaluationContext)));
        });
        return restRequestBuilder;
    }

    private void addUriParams(EvaluationContext evaluationContext, RestRequestBuilder restRequestBuilder) {
        this.getBindings().ifPresent(httpRequestDataExpressionBinding -> httpRequestDataExpressionBinding.getUriParameters().forEach(uriParameter -> restRequestBuilder.addUriParam(uriParameter.getName(), this.getParameterValue(uriParameter.getValue(), evaluationContext))));
    }

    private String getParameterValue(Expression expression, EvaluationContext evaluationContext) {
        Object result = expression.evaluate(evaluationContext);
        if (result instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)result;
            result = typedValue.getValue();
        }
        if (result instanceof String | result instanceof Integer | result instanceof Long | result instanceof Double) {
            return RestSdkUtils.stringValue(result);
        }
        throw new IllegalArgumentException(String.format("Expression '%s' did not return a String but `%s`", expression, result != null ? result.getClass().getSimpleName() : "null"));
    }
}

