/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.binding;

/**
 * Describes a parameter bound to an http request. The key is the parameter name, and the value can be an expression or a fixed
 * value.
 *
 * @since 1.0
 */
public class ParameterBinding {

  private final String key;
  private final String value;

  public ParameterBinding(String key, String value) {
    this.key = key;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public static class BodyBinding extends ParameterBinding {

    public BodyBinding(String value) {
      super("body", value);
    }
  }
}
