/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import org.mule.metadata.api.builder.TypeBuilder;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

import org.everit.json.schema.Schema;

public class ParsingContext {

  private Map<Schema, TypeBuilder<?>> builder = new IdentityHashMap<>();

  public Optional<TypeBuilder<?>> getBuilder(Schema schema) {
    return Optional.ofNullable(builder.get(schema));
  }

  public boolean isAlreadyBuild(Schema schema) {
    return getBuilder(schema).isPresent();
  }

  public void registerBuilder(Schema schema, TypeBuilder<?> typedObject) {
    if (!builder.containsKey(schema)) {
      builder.put(schema, typedObject);
    }
  }

}
