/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.getTypedValueOrNull;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;

import java.util.Map;
import java.util.Optional;

/**
 * Base class for an evaluation context builder that manages a global evaluation context.
 *
 * @since 1.0
 */
public abstract class EvaluationContextBuilder {

  private final EvaluationContext globalEvaluationContext;

  public EvaluationContextBuilder(EvaluationContext globalEvaluationContext) {
    this.globalEvaluationContext = globalEvaluationContext;
  }

  /**
   * Builds the evaluation context
   */
  public abstract EvaluationContext build();

  protected void setKeyValue(String name, Object value, Map<String, Object> map) {
    map.put(name, getTypedValueOrNull(value));
  }

  protected Optional<EvaluationContext> buildGlobalEvaluationContext() {
    return Optional.ofNullable(globalEvaluationContext);
  }
}
