/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.resolvers;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;

/**
 * The actual definition of a resolver. This class implements the custom logic of a specific kind of resolver in the
 * {@link #evaluate(EvaluationContext)} method.
 *
 * @since 1.0
 */
public abstract class ResolverDefinition implements ResolverExpression {

  /**
   * Evaluates the context using the resolver definition logic and returns the corresponding result.
   *
   * @param evaluationContext The context where this definition is going to be executed.
   * @return The evaluation result.
   */
  @Override
  public abstract Object evaluate(EvaluationContext evaluationContext);
}
