/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.isBlank;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Utils class for parsing Link header.
 *
 * @since 1.0
 */
public class LinkHeaderUtils {

  private static final String DELIM_LINKS = ",";
  private static final String DELIM_LINK_PARAM = ";";
  private static final String META_REL = "rel";

  /**
   * Parse Link header into a Map of links by its relation
   * 
   * @param linkHeader header to be parsed
   * @return Map of Links by relation
   */
  public static Map<String, String> buildLinkHeaderMap(String linkHeader) {
    if (isBlank(linkHeader)) {
      return Collections.emptyMap();
    }
    Map<String, String> result = new HashMap<>();

    String[] links = linkHeader.split(DELIM_LINKS);
    for (String link : links) {
      String[] segments = link.split(DELIM_LINK_PARAM);
      if (segments.length < 2) {
        continue;
      }

      String linkPart = segments[0].trim();
      if (!linkPart.startsWith("<") || !linkPart.endsWith(">")) {
        continue;
      }
      linkPart = linkPart.substring(1, linkPart.length() - 1);

      for (int i = 1; i < segments.length; i++) {
        String[] rel = segments[i].trim().split("=");
        if (rel.length < 2 || !META_REL.equals(rel[0]))
          continue;

        String relValue = rel[1];
        if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
          relValue = relValue.substring(1, relValue.length() - 1);
        }

        result.put(relValue, linkPart);

      }
    }
    return result;
  }

}
