/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.configuration;

import com.mulesoft.connectivity.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.StreamingTypeValueProvider;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public abstract class RestConfiguration
implements Initialisable {
    @DefaultEncoding
    private String defaultEncoding;
    private Charset charset;
    @Parameter
    @Optional(defaultValue="60")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The timeout for request to the remote service.")
    private Integer responseTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="A time unit which qualifies the Response Timeout}")
    private TimeUnit responseTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @Placement(tab="Advanced")
    @Optional(defaultValue="AUTO")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Defines if the request should be sent using streaming. Setting the value to AUTO will automatically define the best strategy based on the request content.")
    @OfValues(value=StreamingTypeValueProvider.class)
    private String streamingType;
    private StreamingType streamingTypeEnumValue;

    public void initialise() {
        this.charset = Charset.forName(this.defaultEncoding);
        this.streamingTypeEnumValue = StreamingType.valueOf(this.streamingType);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeUnit getResponseTimeoutUnit() {
        return this.responseTimeoutUnit;
    }

    public StreamingType getStreamingType() {
        return this.streamingTypeEnumValue;
    }
}

