/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;

/**
 * RSDK implementation for error handling to generate a reasonPhrase that includes the statusCode.
 *
 * @since 1.0
 */
public final class RestErrorHttpResponseInterceptor implements HttpResponseInterceptor {

  private static final RestErrorHttpResponseInterceptor instance = new RestErrorHttpResponseInterceptor();

  private RestErrorHttpResponseInterceptor() {}

  public static RestErrorHttpResponseInterceptor getInstance() {
    return instance;
  }

  @Override
  public boolean match(InterceptionHttpRequest request, HttpResponse httpResponse, ExpressionLanguage expressionLanguage) {
    return RestError.getErrorByCode(httpResponse.getStatusCode()).isPresent();
  }

  @Override
  public HttpResponse intercept(InterceptionHttpRequest request, HttpResponse httpResponse,
                                ExpressionLanguage expressionLanguage) {
    return HttpResponse.builder()
        .statusCode(httpResponse.getStatusCode())
        .headers(httpResponse.getHeaders())
        .reasonPhrase(httpResponse.getStatusCode() + " " + httpResponse.getReasonPhrase())
        .entity(httpResponse.getEntity())
        .build();
  }
}
