/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.http;

import static java.util.Objects.requireNonNull;
import static java.util.Optional.empty;
import static org.mule.runtime.api.util.IOUtils.toByteArray;

import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;

/**
 * Implementation for an {@link HttpEntity} based on a {@link CursorStreamProvider}.
 *
 * @since 1.0
 */
public class HttpEntityCursorStreamProviderBased implements HttpEntity {

  private CursorStreamProvider cursorStreamProvider;
  private OptionalLong contentLength;

  public HttpEntityCursorStreamProviderBased(CursorStreamProvider cursorStreamProvider, OptionalLong contentLength) {
    requireNonNull(cursorStreamProvider, "cursorStreamProvider cannot be null.");
    requireNonNull(contentLength, "contentLength cannot be null.");

    this.cursorStreamProvider = cursorStreamProvider;
    this.contentLength = contentLength;
  }

  public boolean isStreaming() {
    return true;
  }

  public boolean isComposed() {
    return false;
  }

  public InputStream getContent() {
    return this.cursorStreamProvider.openCursor();
  }

  public byte[] getBytes() throws IOException {
    return toByteArray(this.cursorStreamProvider.openCursor());
  }

  public Collection<HttpPart> getParts() {
    return Collections.emptyList();
  }

  public Optional<Long> getLength() {
    return this.contentLength.isPresent() ? Optional.of(this.contentLength.getAsLong()) : empty();
  }

  public OptionalLong getBytesLength() {
    return this.contentLength;
  }
}
