/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import com.mulesoft.connectivity.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.StreamingTypeValueProvider;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public class ConfigurationOverrides {
    @Parameter
    @ConfigOverride
    @Placement(tab="Advanced")
    @Summary(value="The timeout for request to the remote service.")
    private Integer responseTimeout;
    @Parameter
    @ConfigOverride
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="A time unit which qualifies the Response Timeout}")
    private TimeUnit responseTimeoutUnit;
    @Parameter
    @ConfigOverride
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Defines if the request should be sent using streaming. Setting the value to AUTO will automatically define the best strategy based on the request content.")
    @OfValues(value=StreamingTypeValueProvider.class)
    private String streamingType;

    public int getResponseTimeoutAsMillis() {
        return Long.valueOf(this.responseTimeoutUnit.toMillis(this.responseTimeout.intValue())).intValue();
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeUnit getResponseTimeoutUnit() {
        return this.responseTimeoutUnit;
    }

    public StreamingType getStreamingType() {
        return StreamingType.valueOf(this.streamingType);
    }
}

