/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import com.mulesoft.connectivity.rest.commons.api.configuration.StreamingType;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.interception.RestErrorHttpResponseInterceptor;
import com.mulesoft.connectivity.rest.commons.api.operation.RequestParameters;
import com.mulesoft.connectivity.rest.commons.api.operation.queryparam.CommaQueryParamFormatter;
import com.mulesoft.connectivity.rest.commons.api.operation.queryparam.MultimapQueryParamFormatter;
import com.mulesoft.connectivity.rest.commons.api.operation.queryparam.QueryParamFormatter;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRequestBuilder.class);
    private final String baseUri;
    private String path;
    private final HttpConstants.Method method;
    private String fullUri;
    private final MultiMap<String, String> headers = new CaseInsensitiveMultiMap(false);
    private final MultiMap<String, String> queryParams = new MultiMap();
    private final HashMap<String, String> uriParams = new HashMap();
    private TypedValue<InputStream> body = null;
    private StreamingType streamingType = StreamingType.AUTO;
    private QueryParamFormat queryParamFormat = QueryParamFormat.MULTIMAP;
    private HttpResponseInterceptor httpResponseInterceptor = RestErrorHttpResponseInterceptor.getInstance();

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method) {
        this(baseUri, path, method, null);
    }

    public RestRequestBuilder(String baseUri, String path, HttpConstants.Method method, RequestParameters requestParameters) {
        this.baseUri = baseUri;
        this.path = path;
        this.method = method;
        if (requestParameters != null) {
            this.headers.putAll(requestParameters.getCustomHeaders());
            this.queryParams.putAll(requestParameters.getCustomQueryParams());
        }
    }

    public String getUri() {
        return this.buildRequestUri();
    }

    public String getMethod() {
        return this.method.name();
    }

    public RestRequestBuilder addUriParam(String placeholderKey, Object value) {
        if (value != null) {
            this.uriParams.put(placeholderKey, RestSdkUtils.stringValue(value));
        }
        return this;
    }

    public RestRequestBuilder addUriParams(String key, List<?> values) {
        if (values != null && !values.isEmpty()) {
            values.forEach(value -> this.addUriParam(key, value));
        }
        return this;
    }

    public RestRequestBuilder addHeader(String key, Object value) {
        if (value != null) {
            this.headers.put((Object)key, (Object)RestSdkUtils.stringValue(value));
        }
        return this;
    }

    public RestRequestBuilder addHeaders(String key, List<?> values) {
        if (values != null && !values.isEmpty()) {
            values.forEach(value -> this.addHeader(key, value));
        }
        return this;
    }

    public RestRequestBuilder headers(MultiMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    public RestRequestBuilder addQueryParam(String key, Object value) {
        if (value != null) {
            this.queryParams.put((Object)key, (Object)RestSdkUtils.stringValue(value));
        }
        return this;
    }

    public RestRequestBuilder addQueryParams(String key, List<?> values) {
        if (values != null && !values.isEmpty()) {
            values.forEach(value -> this.addQueryParam(key, value));
        }
        return this;
    }

    public void clearQueryParams() {
        this.queryParams.clear();
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public RestRequestBuilder queryParams(MultiMap<String, String> queryParams) {
        this.queryParams.putAll(queryParams);
        return this;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public Map<String, String> getUriParams() {
        return Collections.unmodifiableMap(this.uriParams);
    }

    public RestRequestBuilder setQueryParamFormat(QueryParamFormat queryParamFormat) {
        this.queryParamFormat = queryParamFormat;
        return this;
    }

    public RestRequestBuilder setBody(TypedValue<InputStream> body, StreamingType streamingType) {
        this.body = body;
        this.streamingType = streamingType;
        return this;
    }

    public RestRequestBuilder responseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        Objects.requireNonNull(httpResponseInterceptor);
        this.httpResponseInterceptor = httpResponseInterceptor;
        return this;
    }

    public HttpResponseInterceptor getResponseInterceptor() {
        return this.httpResponseInterceptor;
    }

    private HttpEntity getStreamingConfiguredHttpEntity(TypedValue<InputStream> body, StreamingType streamingType) {
        if (body != null) {
            byte[] bytes = null;
            if (streamingType.equals((Object)StreamingType.ALWAYS)) {
                this.headers.remove((Object)"Content-Length");
                this.headers.remove((Object)"Transfer-Encoding");
                this.headers.put((Object)"Transfer-Encoding", (Object)"chunked");
            } else if (streamingType.equals((Object)StreamingType.NEVER)) {
                bytes = this.setNeverStreamingContentLength(body);
            } else {
                this.setAutoContentLengthHeader(body);
            }
            this.inferContentTypeFromBody(body);
            if (body.getValue() != null) {
                if (bytes != null) {
                    return new ByteArrayHttpEntity(bytes);
                }
                return new InputStreamHttpEntity((InputStream)body.getValue());
            }
        }
        return null;
    }

    private void inferContentTypeFromBody(TypedValue<InputStream> body) {
        MediaType mediaType;
        if (!this.headers.containsKey((Object)"Content-Type") && (mediaType = body.getDataType().getMediaType()) != null && !mediaType.getPrimaryType().equals("*")) {
            this.headers.put((Object)"Content-Type", (Object)mediaType.toRfcString());
        }
    }

    private byte[] setNeverStreamingContentLength(TypedValue<InputStream> body) {
        String customLength = (String)this.headers.get((Object)"Content-Length");
        byte[] bytes = null;
        if (customLength == null) {
            if (body.getByteLength().isPresent()) {
                this.addHeader("Content-Length", body.getByteLength().getAsLong());
            } else if (body.getValue() != null) {
                bytes = IOUtils.toByteArray((InputStream)((InputStream)body.getValue()));
                this.addHeader("Content-Length", bytes.length);
            }
        }
        this.headers.remove((Object)"Transfer-Encoding");
        return bytes;
    }

    private void setAutoContentLengthHeader(TypedValue<InputStream> body) {
        String customLength = (String)this.headers.get((Object)"Content-Length");
        boolean isChunked = "chunked".equals(this.headers.get((Object)"Transfer-Encoding"));
        if (body.getByteLength().isPresent()) {
            boolean addHeader = true;
            String length = RestSdkUtils.stringValue(body.getByteLength().getAsLong());
            if (customLength != null) {
                LOGGER.warn("Invoking URI {} with body of known length {}. However, a {} header with value {} was manually specified. Will proceed with the custom value.", new Object[]{this.getUri(), length, "Content-Length", customLength});
                addHeader = false;
            }
            if (isChunked) {
                LOGGER.debug("Invoking URI {} with a manually set {}: {} header, even though body is of known length {}. Skipping automatic addition of {} header", new Object[]{this.getUri(), "Transfer-Encoding", "chunked", length, "Content-Length"});
                addHeader = false;
            }
            if (addHeader) {
                this.headers.put((Object)"Content-Length", (Object)length);
            }
        } else if (customLength == null && !isChunked) {
            this.headers.put((Object)"Transfer-Encoding", (Object)"chunked");
        }
    }

    public HttpRequest build() {
        HttpEntity httpEntity = this.getStreamingConfiguredHttpEntity(this.body, this.streamingType);
        HttpRequestBuilder builder = (HttpRequestBuilder)HttpRequest.builder((boolean)true).uri(this.getUri()).method(this.method).queryParams(this.queryParamFormat.getFormatter().format(this.queryParams)).headers(this.headers);
        if (httpEntity != null) {
            builder.entity(httpEntity);
        }
        return builder.build();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFullUri(String fullUri) {
        this.fullUri = fullUri;
    }

    private String buildRequestUri() {
        if (RestSdkUtils.isNotBlank(this.fullUri)) {
            return this.fullUri;
        }
        String localPath = this.path;
        String localBaseUri = this.baseUri;
        boolean pathStartsWithSlash = localPath != null && localPath.startsWith("/");
        boolean baseEndsInSlash = localBaseUri.endsWith("/");
        if (pathStartsWithSlash && baseEndsInSlash) {
            localPath = localPath.substring(1);
        } else if (!pathStartsWithSlash && !baseEndsInSlash) {
            localBaseUri = localBaseUri + '/';
        }
        localPath = this.applyUriParameters(localPath);
        if (localPath == null) {
            return localBaseUri;
        }
        return localBaseUri + localPath;
    }

    private String applyUriParameters(String path) {
        for (String key : this.uriParams.keySet()) {
            path = path.replace(String.format("{%s}", key), this.uriParams.get(key));
        }
        return path;
    }

    public static enum QueryParamFormat {
        MULTIMAP(new MultimapQueryParamFormatter()),
        COMMA(new CommaQueryParamFormatter());

        private final QueryParamFormatter formatter;

        private QueryParamFormat(QueryParamFormatter formatter) {
            this.formatter = formatter;
        }

        public QueryParamFormatter getFormatter() {
            return this.formatter;
        }
    }
}

