/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.validation.ConnectionValidationSettings;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.streaming.StreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import static org.mule.runtime.api.connection.ConnectionValidationResult.success;

/**
 * Mocked class for Connection providers
 *
 * @since 1.0
 */
public class MockedConnectionProvider implements CachedConnectionProvider<RestConnection> {

  @Override
  public RestConnection connect() throws ConnectionException {
    return new RestConnection() {

      @Override
      public CompletableFuture<Result<InputStream, HttpResponseAttributes>> request(RestRequestBuilder requestBuilder,
                                                                                    int responseTimeoutMillis,
                                                                                    MediaType defaultResponseMediaType,
                                                                                    StreamingHelper streamingHelper) {
        throw new UnsupportedOperationException("Mocked connection, executing this message does not have any real purpose");
      }

      @Override
      public CompletableFuture<Result<String, HttpResponseAttributes>> bodylessRequest(RestRequestBuilder requestBuilder,
                                                                                       int responseTimeoutMillis,
                                                                                       MediaType defaultResponseMediaType,
                                                                                       StreamingHelper streamingHelper) {
        throw new UnsupportedOperationException("Mocked connection, executing this message does not have any real purpose");
      }

      @Override
      public ConnectionValidationResult validate(ConnectionValidationSettings settings, int responseTimeoutMillis) {
        return success();
      }

      @Override
      public String getBaseUri() {
        throw new UnsupportedOperationException("Mocked connection, executing this message does not have any real purpose");
      }

      @Override
      public void stop() {
        throw new UnsupportedOperationException("Mocked connection, executing this message does not have any real purpose");
      }

      @Override
      public Map<String, Object> getBindings() {
        throw new UnsupportedOperationException("Mocked connection, executing this message does not have any real purpose");
      }
    };
  }

  @Override
  public void disconnect(RestConnection restConnection) {
    throw new UnsupportedOperationException("Mocked connection, executing this message does not have any real purpose");
  }

  @Override
  public ConnectionValidationResult validate(RestConnection restConnection) {
    return success();
  }
}
