/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.operation;

import static org.mule.runtime.api.util.MultiMap.emptyMultiMap;
import static org.mule.runtime.extension.api.annotation.param.display.Placement.ADVANCED_TAB;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

/**
 * Groups custom parameters for HTTP request operations.
 *
 * @since 1.0
 */
public class RequestParameters {

  /**
   * Custom query parameters to be sent in the HTTP request.
   */
  @Parameter
  @Optional(defaultValue = "#[null]")
  @Content
  @NullSafe
  @DisplayName("Custom Query Parameters")
  @Placement(tab = ADVANCED_TAB, order = 1)
  private MultiMap<String, String> customQueryParams = emptyMultiMap();

  /**
   * Custom headers to be sent in the HTTP request.
   */
  @Parameter
  @Optional(defaultValue = "#[null]")
  @Content
  @NullSafe
  @DisplayName("Custom Headers")
  @Placement(tab = ADVANCED_TAB, order = 2)
  protected MultiMap<String, String> customHeaders = emptyMultiMap();

  /**
   * @return a {@link MultiMap} containing custom query parameters to be sent in the HTTP request. Parameters returned by this
   *         method will override the ones defined at configuration and operation level.
   */
  public MultiMap<String, String> getCustomQueryParams() {
    return customQueryParams;
  }

  /**
   * @return a {@link MultiMap} containing custom headers to be sent in the HTTP request. Parameters returned by this method will
   *         override the ones defined at configuration and operation level.
   */
  public MultiMap<String, String> getCustomHeaders() {
    return customHeaders;
  }

}
