/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpressionBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.HttpConstants;

public class HttpRequestDataExpression
implements DataExpression {
    public static final String CUSTOM_BINDING = "customBinding";
    private final String path;
    private final String method;
    private final MediaType outputMediaType;
    private final HttpRequestDataExpressionBinding bindings;

    public HttpRequestDataExpression(String path, String method, MediaType outputMediaType, HttpRequestDataExpressionBinding bindings) {
        this.path = path;
        this.method = method;
        this.outputMediaType = outputMediaType;
        this.bindings = bindings;
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        RestConfiguration configuration = (RestConfiguration)evaluationContext.resolveProperty("PROPERTY_CONFIGURATION");
        RestConnection connection = (RestConnection)evaluationContext.resolveProperty("PROPERTY_CONNECTION");
        RestRequestBuilder restRequestBuilder = this.getRestRequestBuilder(evaluationContext);
        return RequestStreamingUtils.doRequestAndConsumeString(connection, configuration, restRequestBuilder, this.outputMediaType, (ExpressionLanguage)evaluationContext.resolveProperty("PROPERTY_EXPRESSION_LANGUAGE"));
    }

    private String getPathTemplate() {
        return this.path;
    }

    private Optional<HttpRequestDataExpressionBinding> getBindings() {
        return Optional.ofNullable(this.bindings);
    }

    private RestRequestBuilder getRestRequestBuilder(EvaluationContext evaluationContext) {
        RestConfiguration configuration = (RestConfiguration)evaluationContext.resolveProperty("PROPERTY_CONFIGURATION");
        RestConnection connection = (RestConnection)evaluationContext.resolveProperty("PROPERTY_CONNECTION");
        RestRequestBuilder restRequestBuilder = new RestRequestBuilder(connection.getBaseUri(), this.getPathTemplate(), HttpConstants.Method.valueOf((String)this.method.toUpperCase()));
        if (configuration.getResponseInterceptorDescriptor() != null) {
            restRequestBuilder.responseInterceptorDescriptor(configuration.getResponseInterceptorDescriptor());
        }
        this.addUriParams(evaluationContext, restRequestBuilder);
        this.getBindings().ifPresent(httpRequestDataExpressionBinding -> {
            httpRequestDataExpressionBinding.getHeaders().forEach(header -> restRequestBuilder.addHeader(header.getName(), this.getParameterValue(header.getValue(), evaluationContext)));
            httpRequestDataExpressionBinding.getQueryParameters().forEach(queryParameter -> restRequestBuilder.addQueryParam(queryParameter.getName(), this.getParameterValue(queryParameter.getValue(), evaluationContext)));
        });
        return restRequestBuilder;
    }

    private void addUriParams(EvaluationContext evaluationContext, RestRequestBuilder restRequestBuilder) {
        this.getBindings().ifPresent(httpRequestDataExpressionBinding -> httpRequestDataExpressionBinding.getUriParameters().forEach(uriParameter -> restRequestBuilder.addUriParam(uriParameter.getName(), this.getParameterValue(uriParameter.getValue(), evaluationContext))));
    }

    private String getParameterValue(Expression expression, EvaluationContext evaluationContext) {
        Object result = expression.evaluate(evaluationContext);
        TypedValue value = TypedValue.of((Object)result);
        BindingContext build = BindingContext.builder().addBinding(CUSTOM_BINDING, value).build();
        ExpressionLanguage expressionLanguage = (ExpressionLanguage)evaluationContext.resolveProperty("PROPERTY_EXPRESSION_LANGUAGE");
        TypedValue parameterValue = expressionLanguage.evaluate(CUSTOM_BINDING, DataType.STRING, build);
        return (String)parameterValue.getValue();
    }
}

