/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output;

import static java.util.Arrays.asList;
import static org.mule.runtime.api.meta.ExpressionSupport.SUPPORTED;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.metadata.resolving.AttributesStaticTypeResolver;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;

import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;

public abstract class HttpResponseAttributesMetadataResolver extends AttributesStaticTypeResolver {

  @Override
  public abstract String getCategoryName();

  @Override
  public final MetadataType getStaticMetadata() {
    BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
    // Keep using the same unique typeId based on this class name no matter it is no longer exported
    // this will allow serialization and flyweight pattern to work in extension model.
    ObjectTypeBuilder objectTypeBuilder = typeBuilder.objectType()
        .id(HttpResponseAttributes.class.getCanonicalName());

    objectTypeBuilder.addField()
        .key("statusCode")
        .required()
        .value(typeBuilder
            .numberType()
            .with(new ClassInformationAnnotation(int.class))
            .integer())
        .with(new ExpressionSupportAnnotation(SUPPORTED));

    ObjectTypeBuilder headersValueType = typeBuilder
        .objectType()
        .with(new ClassInformationAnnotation(MultiMap.class, asList(String.class, String.class)));
    headersValueType.openWith().stringType();
    objectTypeBuilder.addField()
        .key("headers")
        .required()
        .value(headersValueType)
        .with(new ExpressionSupportAnnotation(SUPPORTED));

    objectTypeBuilder.addField()
        .key("reasonPhrase")
        .required()
        .value(typeBuilder.stringType())
        .with(new ExpressionSupportAnnotation(SUPPORTED));

    return objectTypeBuilder.build();
  }

}
