/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.queryparam;

import org.mule.runtime.api.util.MultiMap;

import java.util.Map;

/***
 * Formats the parameters of a request, so that they are sent using the desired format.
 *
 * @since 1.0
 */
public abstract class RequestParameterFormatter {

  /***
   * Formats the parameters of a request, so that they are sent using the desired format. For the input multimap every key/value
   * query parameter will have an entry in the multimap. Each value of the @return multimap will be sent as a key/value in the
   * http request.
   *
   * @param parameters A {@link MultiMap} of query parameters that must be sent in a http request
   * @return A multimap where the query parameters are formatted.
   */
  public MultiMap<String, String> format(Map<String, Object> parameters) {
    return format(parameters, true);
  }

  /***
   * Formats the parameters of a request, so that they are sent using the desired format. For the input multimap every key/value
   * query parameter will have an entry in the multimap. Each value of the @return multimap will be sent as a key/value in the
   * http request.
   *
   * @param parameters A {@link MultiMap} of query parameters that must be sent in a http request
   * @return A multimap where the query parameters are formatted.
   */
  public abstract MultiMap<String, String> format(Map<String, Object> parameters, boolean caseSensitive);
}
