/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.HashMap;
import java.util.Map;

import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class StringHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof StringSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final StringSchema stringSchema = (StringSchema) schema;
    final StringTypeBuilder stringType = root.stringType();

    String formatName = stringSchema.getFormatValidator().formatName();
    Map<String, String> properties = new HashMap<>();
    if (!FormatValidator.NONE.formatName().equals(formatName)) {
      // Using MetadataFormatPropertiesAnnotation to propagate the formatName from JSON schema.
      properties.put("format", formatName);
    }
    processTracing(schema, stringType, handlerManager, parsingContext, properties);

    Integer min = null;
    Integer max = null;

    if (stringSchema.getMinLength() != null && stringSchema.getMinLength() > 0) {
      min = stringSchema.getMinLength();
    }

    if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() > 0) {
      max = stringSchema.getMaxLength();
    }
    if (min != null || max != null) {
      stringType.boundary(min, max);
    }

    if (stringSchema.getPattern() != null) {
      stringType.pattern(stringSchema.getPattern().toString());
    }
    return stringType;
  }
}
