/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.backoff;

import com.google.common.annotations.VisibleForTesting;
import com.mulesoft.connectivity.rest.commons.api.backoff.Result;
import com.mulesoft.connectivity.rest.commons.api.backoff.RetriableCallerConfiguration;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RandomizedExponentialBackoffCaller<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomizedExponentialBackoffCaller.class);
    private final RetriableCallerConfiguration configuration;

    public RandomizedExponentialBackoffCaller(RetriableCallerConfiguration configuration) {
        this.configuration = configuration;
    }

    public T call(Supplier<Result<T>> resultSupplier) throws InterruptedException {
        String retriableRequestId = Long.toString(System.nanoTime());
        Result<T> result = resultSupplier.get();
        int retries = 0;
        while (this.isRetriable(result) && this.configuration.getMaxRetries() > 0 && retries < this.configuration.getMaxRetries()) {
            LOGGER.info("request will be retried. retries: {} maxRetries: {} retriableRequestId: {} reason: {} ", new Object[]{++retries, this.configuration.getMaxRetries(), retriableRequestId, ((Exception)result.getResult()).getMessage()});
            this.sleep(retries, retriableRequestId);
            result = resultSupplier.get();
        }
        if (result.isError()) {
            if (retries == this.configuration.getMaxRetries()) {
                LOGGER.error("retries for this call were exhausted. maxRetries: {} retriableRequestId: {}", (Object)this.configuration.getMaxRetries(), (Object)retriableRequestId);
            }
            LOGGER.error("response is error. retriableRequestId: {} reason: {}", (Object)retriableRequestId, (Object)((Exception)result.getResult()).getMessage());
            throw (RuntimeException)result.getResult();
        }
        LOGGER.info("response success. retries: {} maxRetries: {} retriableRequestId: {}", new Object[]{retries, this.configuration.getMaxRetries(), retriableRequestId});
        return result.getResult();
    }

    private void sleep(int retries, String retriableRequestId) throws InterruptedException {
        long randomizedExponentialBackoff = this.getRandomizedExponentialWaitingTime(retries);
        long delay = this.getSleepWaitingTime(this.configuration.getMaxWaitingValue(), randomizedExponentialBackoff);
        try {
            LOGGER.info("sleeping before retry: retryNumber {} randomlyExponentialDelay {} finalDelay {} retriableRequestId: {}", new Object[]{retries, randomizedExponentialBackoff, delay, retriableRequestId});
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new InterruptedException(e.getMessage());
        }
    }

    @VisibleForTesting
    protected long getSleepWaitingTime(long maxWaitingValue, long randomizedExponentialBackoff) {
        return Math.min(maxWaitingValue, randomizedExponentialBackoff);
    }

    @VisibleForTesting
    protected long getRandomizedExponentialWaitingTime(int retries) {
        double exponential = Math.pow(2.0, retries);
        return (long)(Math.floor(Math.random() * exponential) * 1000.0);
    }

    public abstract boolean isRetriable(Result<T> var1);
}

