/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpResponseBinding;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.api.dw.HttpResponseDWBinding;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.streaming.DataWeaveBasedStreamingHelper;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.SplitPayloadUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public abstract class RestPagingProvider
implements PagingProvider<RestConnection, TypedValue<String>> {
    protected final ExpressionLanguage expressionLanguage;
    protected final int responseTimeout;
    protected final MediaType defaultMediaType;
    private final Function<RestConnection, RestRequestBuilder> requestFactory;
    private final String payloadExpression;
    private final Map<String, Object> parameterBindings;
    private final Map<String, Object> customParameterBindings;
    private boolean stopPaging = false;
    private HttpResponseBinding responseBinding = null;

    public RestPagingProvider(Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, String payloadExpression, MediaType defaultMediaType, Map<String, Object> parameterBindings, Map<String, Object> customParameterBindings, int responseTimeout) {
        this.requestFactory = requestFactory;
        this.expressionLanguage = expressionLanguage;
        this.responseTimeout = responseTimeout;
        this.payloadExpression = payloadExpression;
        this.defaultMediaType = defaultMediaType;
        this.parameterBindings = parameterBindings;
        this.customParameterBindings = customParameterBindings;
    }

    public void cleanPagingAttributes() {
        this.stopPaging = false;
    }

    public RestPagingProvider withResponseBinding(HttpResponseBinding responseBinding) {
        this.responseBinding = responseBinding;
        return this;
    }

    protected abstract void configureRequest(RestRequestBuilder var1);

    public final List<TypedValue<String>> getPage(RestConnection connection) {
        Result<InputStream, HttpResponseAttributes> result;
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        RestRequestBuilder requestBuilder = this.requestFactory.apply(connection);
        this.configureRequest(requestBuilder);
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        try {
            result = connection.request(requestBuilder, this.responseTimeout, this.defaultMediaType, new DataWeaveBasedStreamingHelper(this.expressionLanguage)).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)cause.getMessage()), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
        TypedValue<String> rawPage = RestSdkUtils.consumeStringAndClose(result.getOutput(), result.getMediaType().orElse(this.defaultMediaType), RestSdkUtils.resolveCharset(result.getMediaType(), this.defaultMediaType));
        if (RestSdkUtils.isBlank((CharSequence)rawPage.getValue()) || this.stopPaging) {
            return Collections.emptyList();
        }
        TypedValue<String> postProcessedPage = this.postProcess(rawPage);
        List<TypedValue<String>> page = this.extractPayload(postProcessedPage);
        this.onPage(page, postProcessedPage, result.getAttributes().orElse(null));
        return page;
    }

    private BindingContext getResponseBindingContext(TypedValue<?> content, Map<String, Object> parameterBindings, Map<String, Object> customParameterBindings) {
        BindingContext.Builder builder = BindingContext.builder();
        builder.addBinding("parameters", RestSdkUtils.getTypedValueOrNull(parameterBindings)).addBinding("customParameters", RestSdkUtils.getTypedValueOrNull(customParameterBindings)).addBinding("payload", content);
        return builder.build();
    }

    private TypedValue<String> postProcess(TypedValue<String> rawPage) {
        TypedValue payload;
        if (this.responseBinding == null || this.responseBinding.getBody() == null || RestSdkUtils.isBlank(this.responseBinding.getBody().getValue())) {
            return rawPage;
        }
        String transformationExpression = this.responseBinding.getBody().getValue();
        try {
            BindingContext bindingContext = this.getResponseBindingContext(rawPage, this.parameterBindings, this.customParameterBindings);
            payload = this.expressionLanguage.evaluate(transformationExpression, rawPage.getDataType(), bindingContext);
        }
        catch (ExpressionRuntimeException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to transform server result using the expression '%s'", transformationExpression)));
        }
        return RestSdkUtils.consumeStringAndClose(payload.getValue(), rawPage.getDataType().getMediaType(), RestSdkUtils.resolveCharset(Optional.of(rawPage.getDataType().getMediaType()), this.defaultMediaType));
    }

    public Optional<Integer> getTotalResults(RestConnection connection) {
        return Optional.empty();
    }

    public final void close(RestConnection connection) throws MuleException {
        this.doClose(connection);
    }

    protected abstract void onPage(List<TypedValue<String>> var1, TypedValue<String> var2, HttpResponseAttributes var3);

    protected void stopPaging() {
        this.stopPaging = true;
    }

    protected void doClose(RestConnection connection) throws MuleException {
    }

    protected <T> TypedValue<T> evaluate(TypedValue<String> content, String expression, DataType expectedOutputType, HttpResponseAttributes httpResponseAttributes) {
        return this.expressionLanguage.evaluate(expression, expectedOutputType, this.toBindingContext(content, httpResponseAttributes));
    }

    private List<TypedValue<String>> extractPayload(TypedValue<String> content) {
        TypedValue payload;
        try {
            payload = this.expressionLanguage.evaluate(this.payloadExpression, content.getDataType(), this.toBindingContext(content));
        }
        catch (ExpressionRuntimeException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to extract payload from expression: %s", this.payloadExpression)), (Throwable)e);
        }
        Iterator<TypedValue<?>> iterator = SplitPayloadUtils.split(this.expressionLanguage, payload, this.payloadExpression);
        return RestSdkUtils.toList(iterator, content.getDataType().getMediaType(), this.defaultMediaType);
    }

    private BindingContext toBindingContext(TypedValue<String> content) {
        return this.toBindingContext(content, null);
    }

    protected BindingContext toBindingContext(TypedValue<String> content, HttpResponseAttributes httpResponseAttributes) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", content);
        HttpResponseDWBinding httpResponseBinding = new HttpResponseDWBinding(content, httpResponseAttributes);
        builder.addBinding(DWBindings.RESPONSE.getBinding(), TypedValue.of((Object)httpResponseBinding));
        if (httpResponseAttributes != null) {
            builder.addBinding("attributes", TypedValue.of((Object)httpResponseAttributes));
        }
        return builder.build();
    }
}

