/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.util.List;

//TODO tracker: decoupled ConnectorModelParameter from Parameter to remove the valueResolverReference from the web-api module
public class ConnectorModelParameter extends Parameter {

  private final ValueResolverReference valueResolverReference;

  public ConnectorModelParameter(String displayName,
                                 String externalName,
                                 ParameterType parameterType,
                                 TypeDefinition typeDefinition,
                                 String description,
                                 boolean required,
                                 String defaultValue,
                                 boolean password,
                                 List<String> collisionInternalNames, ValueResolverReference valueResolverReference) {

    super(buildParameterInternalName(externalName, collisionInternalNames, parameterType),
          displayName,
          externalName,
          typeDefinition,
          description,
          required,
          defaultValue,
          password);
    this.valueResolverReference = valueResolverReference;
  }


  public ValueResolverReference getValueResolverReference() {
    return valueResolverReference;
  }
}
