/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

/**
 * An assertion that must be done over the server response for the connection validation request.
 * Allows defining a validation expression, that will be run on the server response, and an optional error template expression,
 * that allows generating a custom error message using the data present in the server response.
 */
public class TestConnectionValidationConfig {

  private final String validationExpression;
  private final String errorTemplateExpression;

  public TestConnectionValidationConfig(String validationExpression, String errorTemplateExpression) {
    this.validationExpression = validationExpression;
    this.errorTemplateExpression = errorTemplateExpression;
  }

  public String getValidationExpression() {
    return validationExpression;
  }

  public String getErrorTemplateExpression() {
    return errorTemplateExpression;
  }
}
