/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIJsonTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIXmlTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import org.apache.commons.lang.StringUtils;

public class ConnectorTypeSchemaBuilder {
    private final TypeSchemaPool typeSchemaPool;

    public ConnectorTypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaPool = typeSchemaPool;
    }

    public TypeSchema buildTypeSchema(APITypeSchemaModel apiTypeSchemaModel) {
        TypeSchema typeSchema;
        if (apiTypeSchemaModel == null) {
            return null;
        }
        if (apiTypeSchemaModel instanceof APIXmlTypeSchemaModel) {
            APIXmlTypeSchemaModel apiXmlSchema = (APIXmlTypeSchemaModel)apiTypeSchemaModel;
            typeSchema = new XmlTypeSchema((String)apiXmlSchema.getSchemaSupplier().get(), apiXmlSchema.getElementName(), apiXmlSchema.getPath());
        } else if (apiTypeSchemaModel instanceof APIJsonTypeSchemaModel) {
            APIJsonTypeSchemaModel apiXmlSchema = (APIJsonTypeSchemaModel)apiTypeSchemaModel;
            typeSchema = new JsonTypeSchema(apiXmlSchema.getSchemaSupplier());
        } else {
            typeSchema = new CustomTypeSchema(apiTypeSchemaModel.getSchemaSupplier(), apiTypeSchemaModel.getMediaType());
        }
        return this.getUniqueTypeSchema(typeSchema);
    }

    public TypeSchema buildTypeSchema(String rawSchema) {
        if (XmlUtils.isXmlSchema((String)rawSchema)) {
            return this.getUniqueTypeSchema(new XmlTypeSchema(rawSchema));
        }
        return this.getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }

    private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
        if (typeSchema != null && StringUtils.isNotBlank((String)typeSchema.getRawSchema())) {
            return this.typeSchemaPool.getUniqueTypeSchema(typeSchema);
        }
        return typeSchema;
    }
}

