/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;

import java.util.List;

public class OAuth2ClientCredentialsScheme extends OAuth2Scheme {

  public OAuth2ClientCredentialsScheme(String displayName, String authorizationUri, String accessTokenUri, List<String> scopes,
                                       List<Parameter> queryParameters, List<Parameter> headers,
                                       TestConnectionConfig testConnectionConfig) {
    super(displayName, GrantType.CLIENT_CREDENTIALS, authorizationUri, accessTokenUri, scopes, queryParameters, headers,
          testConnectionConfig);
  }

}
