/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil.generateHashCode;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolverReference;

import java.util.List;

public class Parameter {

  /**
   * XML name used to identify this parameter internally.
   */
  private final String internalName;

  /**
   * Name used to identify this parameter externally.
   * i.e. the name of the query parameter the API is expecting.
   */
  private final String externalName;

  /**
   * User friendly name for this parameter
   */
  private final String displayName;

  private final String description;
  private final boolean required;
  private final String defaultValue;
  private final boolean isPassword;
  private final TypeDefinition typeDefinition;
  private final ValueResolverReference valueResolverReference;

  public Parameter(String displayName,
                   String externalName,
                   ParameterType parameterType,
                   TypeDefinition typeDefinition,
                   String description,
                   boolean required,
                   String defaultValue,
                   boolean password,
                   ValueResolverReference valueResolverReference,
                   List<String> collisionInternalNames) {

    this(buildParameterInternalName(externalName, collisionInternalNames, parameterType),
         displayName,
         externalName,
         typeDefinition,
         description,
         required,
         defaultValue,
         password,
         valueResolverReference);
  }

  protected Parameter(String internalName,
                      String displayName,
                      String externalName,
                      TypeDefinition typeDefinition,
                      String description,
                      boolean required,
                      String defaultValue,
                      boolean password,
                      ValueResolverReference valueResolverReference) {

    this.displayName = displayName;
    this.externalName = externalName;
    this.internalName = internalName;

    this.typeDefinition = typeDefinition;
    this.isPassword = password;
    this.description = description;
    this.required = required;
    this.defaultValue = defaultValue;

    this.valueResolverReference = valueResolverReference;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getExternalName() {
    return externalName;
  }

  public TypeDefinition getTypeDefinition() {
    return typeDefinition;
  }

  public String getDescription() {
    return description;
  }

  public boolean isRequired() {
    return required;
  }

  public String getDefaultValue() {
    return defaultValue;
  }

  public boolean isPassword() {
    return isPassword;
  }

  public ValueResolverReference getValueResolverReference() {
    return valueResolverReference;
  }

  @Override
  public int hashCode() {
    return generateHashCode(internalName, displayName, description, required, defaultValue, typeDefinition,
                            isPassword);
  }

}
