/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorPackage;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorOperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorValueResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConnectorModelBuilder {
    private static final List<Protocol> DEFAULT_PROTOCOLS = new ArrayList<Protocol>();
    private final TypeSchemaPool typeSchemaPool = new TypeSchemaPool();
    private final ConnectorOperationBuilder connectorOperationBuilder = new ConnectorOperationBuilder(this.typeSchemaPool);
    private final ConnectorTriggerBuilder connectorTriggerBuilder = new ConnectorTriggerBuilder(this.typeSchemaPool);
    private final ConnectorValueResolverBuilder connectorValueResolverBuilder = new ConnectorValueResolverBuilder();

    public ConnectorModel buildConnectorModel(APIModel apiModel, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        List<Protocol> protocols = ConnectorModelBuilder.buildProtocols(apiModel);
        List<ConnectorOperation> operations = this.connectorOperationBuilder.buildOperations(apiModel, connectorDescriptor);
        return new ConnectorModel(ConnectorModelBuilder.buildConnectorName(connectorDescriptor), connectorDescriptor.getConnectorDescription(), ConnectorModelBuilder.buildMavenGroup(connectorDescriptor), ConnectorModelBuilder.buildMavenArtifactId(connectorDescriptor), ConnectorModelBuilder.buildMavenVersion(connectorDescriptor), ConnectorModelBuilder.buildBasePackage(connectorDescriptor), ConnectorModelBuilder.buildConnectorCategory(connectorDescriptor), ConnectorModelBuilder.buildBaseUri(connectorDescriptor, apiModel, protocols), protocols, operations.stream().filter(x -> !x.isIgnored()).collect(Collectors.toList()), ConnectorModelBuilder.buildPaginations(connectorDescriptor), ConnectorModelBuilder.buildExtensionXml(connectorDescriptor), ConnectorModelBuilder.buildSkipOutputTypeValidation(connectorDescriptor), this.buildQueryParamArrayFormat(connectorDescriptor), this.connectorTriggerBuilder.buildTriggers(connectorDescriptor, operations), this.connectorValueResolverBuilder.buildValueResolvers(connectorDescriptor));
    }

    protected QueryParamArrayFormat buildQueryParamArrayFormat(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(connectorDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        return QueryParamArrayFormat.MULTIMAP;
    }

    private static String buildConnectorName(ConnectorDescriptor connectorDescriptor) {
        String connectorName = connectorDescriptor.getConnectorName().trim();
        if (connectorName.toLowerCase().endsWith("api")) {
            connectorName = connectorName.substring(0, connectorName.lastIndexOf("api"));
        }
        if (connectorName.toLowerCase().endsWith("connector")) {
            return connectorName;
        }
        return connectorName + " Connector";
    }

    private static Boolean buildSkipOutputTypeValidation(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getSkipOutputTypeValidation();
    }

    private static String buildExtensionXml(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getExtensionXml())) {
            return connectorDescriptor.getExtensionXml();
        }
        return XmlUtils.getXmlName((String)connectorDescriptor.getConnectorName());
    }

    private static String buildBasePackage(ConnectorDescriptor connectorDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getBaseJavaPackage())) {
            return connectorDescriptor.getBaseJavaPackage();
        }
        return ConnectorPackage.buildBasePackage(connectorDescriptor.getConnectorName());
    }

    private static List<Protocol> buildProtocols(APIModel apiModel) {
        return apiModel.getProtocols().isEmpty() ? DEFAULT_PROTOCOLS : apiModel.getProtocols().stream().map(Protocol::getFromString).collect(Collectors.toList());
    }

    private static String buildMavenGroup(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenGroupUnwantedCharacters((String)connectorDescriptor.getConnectorGav().getGroupId());
    }

    private static String buildMavenArtifactId(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenArtifactUnwantedCharacters((String)connectorDescriptor.getConnectorGav().getArtifactId());
    }

    private static String buildMavenVersion(ConnectorDescriptor connectorDescriptor) {
        return XmlUtils.removeMavenVersionUnwantedCharacters((String)connectorDescriptor.getConnectorGav().getVersion());
    }

    private static ConnectorCategory buildConnectorCategory(ConnectorDescriptor connectorDescriptor) {
        return ConnectorCategory.fromString(connectorDescriptor.getConnectorCategory());
    }

    private static BaseUri buildBaseUri(ConnectorDescriptor connectorDescriptor, APIModel apiModel, List<Protocol> protocols) {
        if (connectorDescriptor.getBaseUri() == null) {
            return new BaseUri(apiModel.getBaseUri(), apiModel.getApiVersion(), protocols);
        }
        BaseUri generatedUri = new BaseUri(connectorDescriptor.getBaseUri().getValue(), BaseUri.Type.valueOfName(connectorDescriptor.getBaseUri().getType()), apiModel.getApiVersion(), protocols);
        connectorDescriptor.getBaseUri().getMapping().forEach(x -> generatedUri.addMultipleBaseUri(x.getName(), x.getValue(), x.isDefault()));
        return generatedUri;
    }

    private static Map<String, Pagination> buildPaginations(ConnectorDescriptor connectorDescriptor) {
        ArrayList<Pagination> paginations = new ArrayList<Pagination>(connectorDescriptor.getPaginations().size());
        for (PaginationDeclarationDescriptor paginationDescriptor : connectorDescriptor.getPaginations()) {
            paginations.add(new Pagination(paginationDescriptor.getName(), paginationDescriptor.getType(), paginationDescriptor.getPaginationParameterName(), paginationDescriptor.getNextTokenExpression() != null ? paginationDescriptor.getNextTokenExpression().getExpression() : null, paginationDescriptor.getInitialOffset() != null ? paginationDescriptor.getInitialOffset() : null, paginationDescriptor.getInitialPageNumber() != null ? paginationDescriptor.getInitialPageNumber() : null, paginationDescriptor.getPagingResponseExpression() != null ? paginationDescriptor.getPagingResponseExpression().getExpression() : null));
        }
        HashMap<String, Pagination> paginationMap = new HashMap<String, Pagination>();
        paginations.forEach(paging -> paginationMap.put(paging.getName(), (Pagination)paging));
        return paginationMap;
    }

    static {
        DEFAULT_PROTOCOLS.add(Protocol.HTTP);
        DEFAULT_PROTOCOLS.add(Protocol.HTTPS);
    }
}

