/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverBindingParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ValueResolverParameterDescriptor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ConnectorValueResolverBuilder {
    public List<ValueResolver> buildValueResolvers(ConnectorDescriptor connectorDescriptor) {
        if (connectorDescriptor.getValueResolvers() == null) {
            return Collections.emptyList();
        }
        return connectorDescriptor.getValueResolvers().stream().map(this::buildValueResolver).collect(Collectors.toList());
    }

    private ValueResolver buildValueResolver(ValueResolverDescriptor valueResolverDescriptor) {
        return new ValueResolver(valueResolverDescriptor.getName(), valueResolverDescriptor.getPath(), this.buildMethod(valueResolverDescriptor), valueResolverDescriptor.getItems().getExtraction().getExpression(), valueResolverDescriptor.getItems().getValue().getExpression(), this.buildDisplayNameExpression(valueResolverDescriptor), this.buildValuerResolverParameters(valueResolverDescriptor.getParameters()), this.buildValueResolverBindings(valueResolverDescriptor.getBinding()));
    }

    private HTTPMethod buildMethod(ValueResolverDescriptor valueResolverDescriptor) {
        return HTTPMethod.fromString(valueResolverDescriptor.getMethod().getName());
    }

    private String buildDisplayNameExpression(ValueResolverDescriptor valueResolverDescriptor) {
        return valueResolverDescriptor.getItems().getDisplayName() != null ? valueResolverDescriptor.getItems().getDisplayName().getExpression() : null;
    }

    private List<ParameterBinding> buildValueResolverBindings(ValueResolverBindingDescriptor binding) {
        LinkedList<ParameterBinding> parameterBindings = new LinkedList<ParameterBinding>();
        if (binding != null) {
            parameterBindings.addAll(this.getParameterBindings(binding.getUriParameters(), ParameterType.URI));
            parameterBindings.addAll(this.getParameterBindings(binding.getQueryParameters(), ParameterType.QUERY));
            parameterBindings.addAll(this.getParameterBindings(binding.getHeaders(), ParameterType.HEADER));
        }
        return parameterBindings;
    }

    private List<ParameterBinding> getParameterBindings(List<ValueResolverBindingParameterDescriptor> uriParameters, ParameterType uri) {
        return uriParameters.stream().map(x -> new ParameterBinding(uri, x.getName(), x.getValue().getExpression())).collect(Collectors.toList());
    }

    private List<ValueResolverParameter> buildValuerResolverParameters(List<ValueResolverParameterDescriptor> parameters) {
        return parameters.stream().map(x -> new ValueResolverParameter(x.getName(), this.buildParameterType(x.getType()))).collect(Collectors.toList());
    }

    private ParameterDataType buildParameterType(DataTypeDescriptor type) {
        return ParameterDataType.forName(type.getName());
    }
}

