/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;

import java.util.List;

public class ValueResolver {

  private final String internalName;
  private final String name;

  private final String path;
  private final HTTPMethod method;

  private final String itemsExpression;
  private final String valueExpression;
  private final String displayNameExpression;

  private final List<ValueResolverParameter> parameters;
  private final List<ParameterBinding> parameterBindings;

  public ValueResolver(String name, String path, HTTPMethod method,
                       String itemsExpression, String valueExpression, String displayNameExpression,
                       List<ValueResolverParameter> parameters,
                       List<ParameterBinding> parameterBindings) {
    this.internalName = getXmlName(name);
    this.name = name;

    this.path = path;
    this.method = method;

    this.itemsExpression = itemsExpression;
    this.valueExpression = valueExpression;
    this.displayNameExpression = displayNameExpression;
    this.parameters = parameters;
    this.parameterBindings = parameterBindings;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getName() {
    return name;
  }

  public String getItemsExpression() {
    return itemsExpression;
  }

  public String getValueExpression() {
    return valueExpression;
  }

  public String getDisplayNameExpression() {
    return displayNameExpression;
  }

  public List<ValueResolverParameter> getParameters() {
    return parameters;
  }

  public List<ParameterBinding> getParameterBindings() {
    return parameterBindings;
  }

  public String getPath() {
    return path;
  }

  public HTTPMethod getMethod() {
    return method;
  }
}
