/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueresolver.ValueResolverReference;
import java.util.List;

public class Parameter {
    private final String internalName;
    private final String externalName;
    private final String displayName;
    private final String description;
    private final boolean required;
    private final String defaultValue;
    private final boolean isPassword;
    private final TypeDefinition typeDefinition;
    private final ValueResolverReference valueResolverReference;

    public Parameter(String displayName, String externalName, ParameterType parameterType, TypeDefinition typeDefinition, String description, boolean required, String defaultValue, boolean password, ValueResolverReference valueResolverReference, List<String> collisionInternalNames) {
        this(NamingUtil.buildParameterInternalName(externalName, collisionInternalNames, parameterType), displayName, externalName, typeDefinition, description, required, defaultValue, password, valueResolverReference);
    }

    protected Parameter(String internalName, String displayName, String externalName, TypeDefinition typeDefinition, String description, boolean required, String defaultValue, boolean password, ValueResolverReference valueResolverReference) {
        this.displayName = displayName;
        this.externalName = externalName;
        this.internalName = internalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.description = description;
        this.required = required;
        this.defaultValue = defaultValue;
        this.valueResolverReference = valueResolverReference;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public ValueResolverReference getValueResolverReference() {
        return this.valueResolverReference;
    }

    public int hashCode() {
        return HashCodeUtil.generateHashCode(this.internalName, this.displayName, this.description, this.required, this.defaultValue, this.typeDefinition, this.isPassword);
    }
}

